/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.common;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariablePropertyValueHelper {
    private static final Logger log = LoggerFactory.getLogger(VariablePropertyValueHelper.class);

    public static BigDecimal getValue(Class<?> clazz, String propertyName, Object object) {
        if (Objects.isNull(clazz) || StringUtils.isEmpty((CharSequence)propertyName) || Objects.isNull(object)) {
            throw new RuntimeException("\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570\uff01");
        }
        Field filed = clazz.getDeclaredField(propertyName);
        filed.setAccessible(true);
        Object o = filed.get(object);
        if (Objects.isNull(o)) {
            return BigDecimal.ZERO;
        }
        if (o instanceof BigDecimal) {
            return new BigDecimal(o.toString());
        }
        if (o instanceof Integer) {
            return BigDecimal.valueOf(Integer.parseInt(o.toString()));
        }
        if (o instanceof Float) {
            return BigDecimal.valueOf(Float.parseFloat(o.toString()));
        }
        if (o instanceof Double) {
            return BigDecimal.valueOf(Double.parseDouble(o.toString()));
        }
        if (o instanceof String) {
            try {
                return new BigDecimal(o.toString());
            }
            catch (Exception e) {
                throw new RuntimeException("\u503c[" + o + "]\u5b57\u6bb5\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38\uff1a" + e.getMessage(), e);
            }
        }
        return BigDecimal.ZERO;
    }
}

