/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.configure.common;

import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.dto.MainOnedaySalesDataDto;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.service.MainOnedaySaleDataService;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.vo.MainOnedaySalesDataVo;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import com.biz.crm.tpm.business.third.system.sdk.dto.TpmProfitabilityAnalysisDto;
import com.biz.crm.tpm.business.third.system.sdk.service.TpmProfitabilityAnalysisService;
import com.biz.crm.tpm.business.variable.local.repository.ConVariableDetailRepository;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.dto.ConVariableDetailDto;
import com.biz.crm.tpm.business.variable.sdk.enums.ConItemTypeEnum;
import com.biz.crm.tpm.business.variable.sdk.vo.ConVariableDetailVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Component
public class ConVariableRegisterParamHandler {
    private static final Logger log = LoggerFactory.getLogger(ConVariableRegisterParamHandler.class);
    @Autowired(required=false)
    private ConVariableDetailRepository conVariableDetailRepository;
    @Autowired(required=false)
    private MainOnedaySaleDataService mainOnedaySaleDataService;
    @Autowired(required=false)
    private SalesOrgSubComOrgService salesOrgSubComOrgService;
    @Autowired(required=false)
    private TpmProfitabilityAnalysisService tpmProfitabilityAnalysisService;
    @Autowired(required=false)
    private SalesGoalService salesGoalService;

    public List<MainOnedaySalesDataVo> findExcludeData(CalculateDto calculateDto, String variableCode) {
        String auditFormulaCode = calculateDto.getAuditFormulaCode();
        Assert.hasText((String)auditFormulaCode, (String)"\u6838\u9500\u516c\u5f0f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty((Collection)calculateDto.getCustomerCodeList(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)calculateDto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)calculateDto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        ConVariableDetailDto detailDto = new ConVariableDetailDto();
        detailDto.setAuditFormulaCode(auditFormulaCode);
        detailDto.setVariableCode(variableCode);
        List<ConVariableDetailVo> itemDetail = this.conVariableDetailRepository.getItemDetail(detailDto);
        MainOnedaySalesDataDto salesDataDto = new MainOnedaySalesDataDto();
        salesDataDto.setCustomerCodeList((List)Lists.newArrayList((Iterable)calculateDto.getCustomerCodeList()));
        salesDataDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        salesDataDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        if (!CollectionUtils.isEmpty(itemDetail)) {
            List filterList = itemDetail.stream().filter(e -> Objects.nonNull(e.getBeginTime()) && Objects.nonNull(e.getEndTime())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(filterList)) {
                ConVariableDetailVo variableDetailVo = itemDetail.get(0);
                salesDataDto.setStartTimeOrDate(DateUtil.format((Date)variableDetailVo.getBeginTime(), (String)"yyyy-MM-dd"));
                salesDataDto.setEndTimeOrDate(DateUtil.format((Date)variableDetailVo.getEndTime(), (String)"yyyy-MM-dd"));
            }
            salesDataDto.setExcludeProductCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.GOODS));
            salesDataDto.setExcludeProductItemCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.ITEM));
            salesDataDto.setExcludeProductCategoryCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.CATEGORY));
            salesDataDto.setExcludeProductBrandCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.BRAND));
        }
        if (StringUtils.isEmpty((CharSequence)salesDataDto.getStartTimeOrDate()) && StringUtils.isEmpty((CharSequence)salesDataDto.getEndTimeOrDate())) {
            Assert.notNull((Object)calculateDto.getStartTimeOrDate(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)calculateDto.getEndTimeOrDate(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            salesDataDto.setStartTimeOrDate(DateUtil.format((Date)calculateDto.getStartTimeOrDate(), (String)"yyyy-MM-dd"));
            salesDataDto.setEndTimeOrDate(DateUtil.format((Date)calculateDto.getEndTimeOrDate(), (String)"yyyy-MM-dd"));
        }
        salesDataDto.setStartTimeOrDate(salesDataDto.getStartTimeOrDate().replaceAll("-", ""));
        salesDataDto.setEndTimeOrDate(salesDataDto.getEndTimeOrDate().replaceAll("-", ""));
        return this.mainOnedaySaleDataService.listMainOnedaySalesData(salesDataDto);
    }

    public List<MainOnedaySalesDataVo> findIncludeData(CalculateDto calculateDto, String variableCode) {
        String auditFormulaCode = calculateDto.getAuditFormulaCode();
        Assert.hasText((String)auditFormulaCode, (String)"\u6838\u9500\u516c\u5f0f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty((Collection)calculateDto.getCustomerCodeList(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)calculateDto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)calculateDto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        ConVariableDetailDto detailDto = new ConVariableDetailDto();
        detailDto.setAuditFormulaCode(auditFormulaCode);
        detailDto.setVariableCode(variableCode);
        List<ConVariableDetailVo> itemDetail = this.conVariableDetailRepository.getItemDetail(detailDto);
        MainOnedaySalesDataDto salesDataDto = new MainOnedaySalesDataDto();
        salesDataDto.setCustomerCodeList((List)Lists.newArrayList((Iterable)calculateDto.getCustomerCodeList()));
        salesDataDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        salesDataDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        if (!CollectionUtils.isEmpty(itemDetail)) {
            List filterList = itemDetail.stream().filter(e -> Objects.nonNull(e.getBeginTime()) && Objects.nonNull(e.getEndTime())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(filterList)) {
                ConVariableDetailVo variableDetailVo = itemDetail.get(0);
                salesDataDto.setStartTimeOrDate(DateUtil.format((Date)variableDetailVo.getBeginTime(), (String)"yyyy-MM-dd"));
                salesDataDto.setEndTimeOrDate(DateUtil.format((Date)variableDetailVo.getEndTime(), (String)"yyyy-MM-dd"));
            }
            salesDataDto.setProductCodes(this.getExcludeList(itemDetail, ConItemTypeEnum.INCLUDE_GOODS));
            salesDataDto.setExcludeProductCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.GOODS));
            salesDataDto.setExcludeProductItemCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.ITEM));
            salesDataDto.setExcludeProductCategoryCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.CATEGORY));
            salesDataDto.setExcludeProductBrandCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.BRAND));
        }
        if (CollectionUtils.isEmpty((Collection)salesDataDto.getProductCodes())) {
            if (StringUtils.isNotEmpty((CharSequence)calculateDto.getProductCode())) {
                salesDataDto.setProductCodes(Arrays.asList(calculateDto.getProductCode().split(",")));
            } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getItemCode())) {
                salesDataDto.setProductItemCode(calculateDto.getItemCode());
            } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getCategoryCode())) {
                salesDataDto.setProductCategoryCode(calculateDto.getCategoryCode());
            } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getBrandCode()) && !StringUtils.equals((CharSequence)"130000", (CharSequence)calculateDto.getBrandCode())) {
                salesDataDto.setProductBrandCode(calculateDto.getBrandCode());
            } else if (StringUtils.isEmpty((CharSequence)calculateDto.getBrandCode())) {
                throw new RuntimeException("\u4ea7\u54c1\u548c\u4ea7\u54c1\u5c42\u7ea7\u5168\u90e8\u4e3a\u7a7a\uff01");
            }
        }
        if (StringUtils.isEmpty((CharSequence)salesDataDto.getStartTimeOrDate()) && StringUtils.isEmpty((CharSequence)salesDataDto.getEndTimeOrDate())) {
            Assert.notNull((Object)calculateDto.getStartTimeOrDate(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)calculateDto.getEndTimeOrDate(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            salesDataDto.setStartTimeOrDate(DateUtil.format((Date)calculateDto.getStartTimeOrDate(), (String)"yyyy-MM-dd"));
            salesDataDto.setEndTimeOrDate(DateUtil.format((Date)calculateDto.getEndTimeOrDate(), (String)"yyyy-MM-dd"));
        }
        salesDataDto.setStartTimeOrDate(salesDataDto.getStartTimeOrDate().replaceAll("-", ""));
        salesDataDto.setEndTimeOrDate(salesDataDto.getEndTimeOrDate().replaceAll("-", ""));
        return this.mainOnedaySaleDataService.listMainOnedaySalesData(salesDataDto);
    }

    public BigDecimal findProfitabilityAnalysisFilterData(CalculateDto calculateDto, String variableCode) {
        String auditFormulaCode = calculateDto.getAuditFormulaCode();
        Assert.hasText((String)auditFormulaCode, (String)"\u6838\u9500\u516c\u5f0f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.notBlank((CharSequence)calculateDto.getCustomerErpCode(), (String)"\u5ba2\u6237MDG\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List subComOrgVos = this.salesOrgSubComOrgService.listBySubComOrgCodeList((List)Lists.newArrayList((Object[])new String[]{calculateDto.getCustomerErpCode()}));
        Validate.notEmpty((Collection)subComOrgVos, (String)"\u672a\u83b7\u53d6\u5230\u5206\u5b50\u516c\u53f8\u4e0e\u9500\u552e\u673a\u6784\u5bf9\u5e94\u5173\u7cfb", (Object[])new Object[0]);
        String salesOrgCode = ((SalesOrgSubComOrgVo)subComOrgVos.get(0)).getSalesOrgCode();
        ConVariableDetailDto detailDto = new ConVariableDetailDto();
        detailDto.setAuditFormulaCode(auditFormulaCode);
        detailDto.setVariableCode(variableCode);
        List<ConVariableDetailVo> itemDetail = this.conVariableDetailRepository.getItemDetail(detailDto);
        TpmProfitabilityAnalysisDto dto = new TpmProfitabilityAnalysisDto();
        dto.setCompanyCode(salesOrgCode);
        dto.setSpartCode("11");
        if (StringUtils.isNotEmpty((CharSequence)calculateDto.getProductCode())) {
            dto.setMaterialCodes(Arrays.asList(calculateDto.getProductCode().split(",")));
        }
        HashMap<String, BigDecimal> pointMap = new HashMap<String, BigDecimal>();
        if (!CollectionUtils.isEmpty(itemDetail)) {
            List<String> includeProductList;
            Map<String, BigDecimal> map = itemDetail.stream().filter(e -> ConItemTypeEnum.INCLUDE_GOODS.getCode().equals(e.getItemType())).collect(Collectors.toMap(ConVariableDetailVo::getItemCode, e -> {
                if (Objects.isNull(e.getPoint())) {
                    return BigDecimal.ONE;
                }
                return e.getPoint();
            }));
            pointMap.putAll(map);
            List filterList = itemDetail.stream().filter(e -> Objects.nonNull(e.getBeginTime()) && Objects.nonNull(e.getEndTime())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(filterList)) {
                ConVariableDetailVo variableDetailVo = (ConVariableDetailVo)filterList.get(0);
                dto.setAccountDateBegin(DateUtil.format((Date)variableDetailVo.getBeginTime(), (String)"yyyy-MM-dd"));
                dto.setAccountDateEnd(DateUtil.format((Date)variableDetailVo.getEndTime(), (String)"yyyy-MM-dd"));
            }
            if (CollectionUtils.isEmpty(includeProductList = this.getExcludeList(itemDetail, ConItemTypeEnum.INCLUDE_GOODS))) {
                dto.setExcludeMaterialCodes(this.getExcludeList(itemDetail, ConItemTypeEnum.GOODS));
                dto.setExcludeItemCodes(this.getExcludeList(itemDetail, ConItemTypeEnum.ITEM));
                dto.setExcludeCategoryCodes(this.getExcludeList(itemDetail, ConItemTypeEnum.CATEGORY));
                dto.setExcludeBrandCodes(this.getExcludeList(itemDetail, ConItemTypeEnum.BRAND));
            } else {
                dto.setMaterialCodes(includeProductList);
            }
        } else {
            return BigDecimal.ZERO;
        }
        if (StringUtils.isEmpty((CharSequence)dto.getAccountDateBegin()) && StringUtils.isEmpty((CharSequence)dto.getAccountDateEnd())) {
            Assert.notNull((Object)calculateDto.getStartTimeOrDate(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)calculateDto.getEndTimeOrDate(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            dto.setAccountDateBegin(DateUtil.format((Date)calculateDto.getStartTimeOrDate(), (String)"yyyy-MM-dd"));
            dto.setAccountDateEnd(DateUtil.format((Date)calculateDto.getEndTimeOrDate(), (String)"yyyy-MM-dd"));
        }
        dto.setAccountDateBegin(dto.getAccountDateBegin().replaceAll("-", ""));
        dto.setAccountDateEnd(dto.getAccountDateEnd().replaceAll("-", ""));
        List vos = this.tpmProfitabilityAnalysisService.listForVariable(dto);
        if (CollectionUtils.isEmpty((Collection)vos)) {
            return BigDecimal.ZERO;
        }
        BigDecimal total = vos.stream().filter(e -> Objects.nonNull(e.getActualIncomeIntax())).map(e -> e.getActualIncomeIntax().multiply(pointMap.getOrDefault(e.getMaterialCode(), BigDecimal.ONE))).reduce(BigDecimal.ZERO, BigDecimal::add);
        return total;
    }

    public List<SalesGoalVo> findExcludeSalesGoalData(CalculateDto calculateDto, String variableCode) {
        String auditFormulaCode = calculateDto.getAuditFormulaCode();
        Assert.hasText((String)auditFormulaCode, (String)"\u6838\u9500\u516c\u5f0f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty((Collection)calculateDto.getCustomerCodeList(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)calculateDto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)calculateDto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        ConVariableDetailDto detailDto = new ConVariableDetailDto();
        detailDto.setAuditFormulaCode(auditFormulaCode);
        detailDto.setVariableCode(variableCode);
        List<ConVariableDetailVo> itemDetail = this.conVariableDetailRepository.getItemDetail(detailDto);
        SalesGoalDto salesGoalDto = new SalesGoalDto();
        salesGoalDto.setCustomerCodeList((List)Lists.newArrayList((Iterable)calculateDto.getCustomerCodeList()));
        salesGoalDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        salesGoalDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        Date startTimeOrDate = null;
        Date endTimeOrDate = null;
        if (!CollectionUtils.isEmpty(itemDetail)) {
            List filterList = itemDetail.stream().filter(e -> Objects.nonNull(e.getBeginTime()) && Objects.nonNull(e.getEndTime())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(filterList)) {
                ConVariableDetailVo variableDetailVo = itemDetail.get(0);
                startTimeOrDate = variableDetailVo.getBeginTime();
                endTimeOrDate = variableDetailVo.getEndTime();
            }
            salesGoalDto.setExcludeProductCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.GOODS));
            salesGoalDto.setExcludeProductItemCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.ITEM));
            salesGoalDto.setExcludeProductCategoryCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.CATEGORY));
            salesGoalDto.setExcludeProductBrandCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.BRAND));
        }
        if (Objects.isNull(startTimeOrDate) && Objects.isNull(endTimeOrDate)) {
            Assert.notNull((Object)calculateDto.getStartTimeOrDate(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)calculateDto.getEndTimeOrDate(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            startTimeOrDate = calculateDto.getStartTimeOrDate();
            endTimeOrDate = calculateDto.getEndTimeOrDate();
        }
        List yearMonths = DateUtil.getBetweenYearMonths(startTimeOrDate, endTimeOrDate, (String)"yyyy-MM");
        salesGoalDto.setYearMonthLySet((Set)Sets.newHashSet((Iterable)yearMonths));
        return this.salesGoalService.listForVariableCal(salesGoalDto);
    }

    public List<SalesGoalVo> findIncludeSalesGoalData(CalculateDto calculateDto, String variableCode) {
        String auditFormulaCode = calculateDto.getAuditFormulaCode();
        Assert.hasText((String)auditFormulaCode, (String)"\u6838\u9500\u516c\u5f0f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty((Collection)calculateDto.getCustomerCodeList(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)calculateDto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)calculateDto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        ConVariableDetailDto detailDto = new ConVariableDetailDto();
        detailDto.setAuditFormulaCode(auditFormulaCode);
        detailDto.setVariableCode(variableCode);
        List<ConVariableDetailVo> itemDetail = this.conVariableDetailRepository.getItemDetail(detailDto);
        SalesGoalDto salesGoalDto = new SalesGoalDto();
        salesGoalDto.setCustomerCodeList((List)Lists.newArrayList((Iterable)calculateDto.getCustomerCodeList()));
        salesGoalDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        salesGoalDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        Date startTimeOrDate = null;
        Date endTimeOrDate = null;
        if (!CollectionUtils.isEmpty(itemDetail)) {
            List filterList = itemDetail.stream().filter(e -> Objects.nonNull(e.getBeginTime()) && Objects.nonNull(e.getEndTime())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(filterList)) {
                ConVariableDetailVo variableDetailVo = itemDetail.get(0);
                startTimeOrDate = variableDetailVo.getBeginTime();
                endTimeOrDate = variableDetailVo.getEndTime();
            }
            salesGoalDto.setIncludeProductCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.INCLUDE_GOODS));
            salesGoalDto.setExcludeProductCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.GOODS));
            salesGoalDto.setExcludeProductItemCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.ITEM));
            salesGoalDto.setExcludeProductCategoryCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.CATEGORY));
            salesGoalDto.setExcludeProductBrandCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.BRAND));
        }
        if (CollectionUtils.isEmpty((Collection)salesGoalDto.getIncludeProductCodeList())) {
            if (StringUtils.isNotEmpty((CharSequence)calculateDto.getProductCode())) {
                salesGoalDto.setIncludeProductCodeList(Arrays.asList(calculateDto.getProductCode().split(",")));
            } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getItemCode())) {
                salesGoalDto.setProductItemCode(calculateDto.getItemCode());
            } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getCategoryCode())) {
                salesGoalDto.setProductCategoryCode(calculateDto.getCategoryCode());
            } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getBrandCode()) && !StringUtils.equals((CharSequence)"130000", (CharSequence)calculateDto.getBrandCode())) {
                salesGoalDto.setProductBrandCode(calculateDto.getBrandCode());
            } else if (StringUtils.isEmpty((CharSequence)calculateDto.getBrandCode())) {
                throw new RuntimeException("\u4ea7\u54c1\u548c\u4ea7\u54c1\u5c42\u7ea7\u5168\u90e8\u4e3a\u7a7a\uff01");
            }
        }
        if (Objects.isNull(startTimeOrDate) && Objects.isNull(endTimeOrDate)) {
            Assert.notNull((Object)calculateDto.getStartTimeOrDate(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)calculateDto.getEndTimeOrDate(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            startTimeOrDate = calculateDto.getStartTimeOrDate();
            endTimeOrDate = calculateDto.getEndTimeOrDate();
        }
        List yearMonths = DateUtil.getBetweenYearMonths(startTimeOrDate, endTimeOrDate, (String)"yyyy-MM");
        salesGoalDto.setYearMonthLySet((Set)Sets.newHashSet((Iterable)yearMonths));
        return this.salesGoalService.listForVariableCal(salesGoalDto);
    }

    private List<String> getExcludeList(List<ConVariableDetailVo> itemDetail, ConItemTypeEnum typeEnum) {
        return itemDetail.stream().filter(e -> StringUtils.equals((CharSequence)typeEnum.getCode(), (CharSequence)e.getItemType()) && StringUtils.isNotEmpty((CharSequence)e.getItemCode())).map(ConVariableDetailVo::getItemCode).collect(Collectors.toList());
    }
}

