/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import com.biz.crm.tpm.business.promotion.plan.sdk.service.GeneralExpensesService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContractAmountRegister
implements FormulaVariableRegister {
    @Autowired(required=false)
    private GeneralExpensesService generalExpensesService;

    public String getVariableCode() {
        return "contractAmount";
    }

    public String getVariableName() {
        return "\u5408\u540c\u91d1\u989d\uff08\u7535\u5546\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);
        list.add(VariableFunctionEnum.WITHHOLDING);
        return list;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notNull((Object)calculateDto.getPromotionPlanCode(), (String)"\u4fc3\u9500\u89c4\u5212\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        BigDecimal contractAmount = this.generalExpensesService.getContractAmount(calculateDto.getPromotionPlanCode());
        HashMap resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), contractAmount);
        return resultMap;
    }
}

