/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.dto.TpmDistribClosePolicyDto;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.service.TpmDistribClosePolicyService;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.TpmDistribClosePolicyVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CostPlacementRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(CostPlacementRegister.class);
    @Autowired(required=false)
    private TpmDistribClosePolicyService distribClosePolicyService;

    public String getVariableCode() {
        return "eCommerceCostPlacement";
    }

    public String getVariableName() {
        return "\u6295\u653e\u8d39\u7528\uff08\u7535\u5546\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WARNING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WITHHOLDING);
        return list;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notNull((Object)calculateDto.getProductCode(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getDate(), (String)"\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getEstoreCustomerLevel(), (String)"\u7535\u5546\u5ba2\u6237\u7b49\u7ea7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        log.info("\u6295\u653e\u8d39\u75281:{}", (Object)JSONObject.toJSONString((Object)calculateDto));
        SimpleDateFormat format = DateUtil.date_yyyy_MM_dd;
        TpmDistribClosePolicyDto distribClosePolicy = new TpmDistribClosePolicyDto();
        distribClosePolicy.setStartDate(format.format(calculateDto.getDate()));
        distribClosePolicy.setCustomerCode(calculateDto.getCustomerCode());
        distribClosePolicy.setProductCode(calculateDto.getProductCode());
        distribClosePolicy.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        BigDecimal resultDecimal = BigDecimal.ZERO;
        log.info("\u6295\u653e\u8d39\u75282:{}", (Object)JSONObject.toJSONString((Object)distribClosePolicy));
        List list = this.distribClosePolicyService.findDistribClosePolicy(distribClosePolicy);
        if (CollectionUtils.isEmpty((Collection)list)) {
            distribClosePolicy.setCustomerCode("");
            distribClosePolicy.setEstoreCustomerLevel(calculateDto.getEstoreCustomerLevel());
            log.info("\u6295\u653e\u8d39\u75283:{}", (Object)JSONObject.toJSONString((Object)distribClosePolicy));
            list = this.distribClosePolicyService.findDistribClosePolicy(distribClosePolicy);
        }
        if (!CollectionUtils.isEmpty((Collection)list)) {
            resultDecimal = ((TpmDistribClosePolicyVo)list.get(0)).getCostOfPlacement();
            log.info("\u6295\u653e\u8d39\u75284:{}", (Object)resultDecimal);
        }
        if (Objects.isNull(resultDecimal)) {
            resultDecimal = BigDecimal.ZERO;
        }
        HashMap resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), resultDecimal);
        return resultMap;
    }
}

