/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import cn.hutool.json.JSONUtil;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1MnjtFullDto;
import com.biz.crm.tpm.business.third.system.sdk.service.Ce1MnjtSdkService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public abstract class DailySalesDataService {
    private static final Logger log = LoggerFactory.getLogger(DailySalesDataService.class);
    @Autowired(required=false)
    private Ce1MnjtSdkService ce1MnjtSdkService;

    public void dailySalesDataVariable(CalculateDto calculate) {
        log.info("\u7535\u5546\u65e5\u9500\u552e\u6570\u636e\u6307\u6807\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr((Object)calculate));
        Validate.notBlank((CharSequence)calculate.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculate.getCustomerErpCode(), (String)"\u5ba2\u6237MDG\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculate.getSalesOrganizationCode(), (String)"\u9500\u552e\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculate.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculate.getChannel(), (String)"\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculate.getYearMonthLy(), (String)"\u6d3b\u52a8\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    public BigDecimal getDailySalesDataValue(CalculateDto calculate, DailySalesValueEnum dailySalesValueEnum) {
        Ce1MnjtFullDto ce1MnjtFull = new Ce1MnjtFullDto();
        ce1MnjtFull.setCustomerCode(calculate.getCustomerErpCode());
        ce1MnjtFull.setSaleOrgCode(calculate.getSalesOrgErpCode());
        ce1MnjtFull.setProductTeamCode(calculate.getBusinessFormatCode());
        ce1MnjtFull.setDistributionChannelCode(calculate.getChannel());
        ce1MnjtFull.setProductCode(calculate.getProductCode());
        String yearMonthLy = calculate.getYearMonthLy();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        String format1 = "";
        try {
            format1 = format.format(format.parse(yearMonthLy));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        format1 = format1.replaceAll("-", "");
        switch (dailySalesValueEnum) {
            case EARLY: {
                ce1MnjtFull.setActivityBeginTime(format1 + "01");
                ce1MnjtFull.setActivityEndTime(format1 + "10");
                break;
            }
            case MID_HALF: {
                ce1MnjtFull.setActivityBeginTime(format1 + "11");
                ce1MnjtFull.setActivityEndTime(format1 + "20");
                break;
            }
        }
        BigDecimal salesIncludingTaxNetTotal = this.ce1MnjtSdkService.getSalesIncludingTaxNetTotal(ce1MnjtFull);
        return salesIncludingTaxNetTotal != null ? salesIncludingTaxNetTotal : BigDecimal.ZERO;
    }

    public static enum DailySalesValueEnum {
        EARLY("early", "\u4e0a\u65ec"),
        MID_HALF("mid-half", "\u4e2d\u65ec");

        private String key;
        private String value;

        private DailySalesValueEnum(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public DailySalesValueEnum getDailySales(String key) {
            DailySalesValueEnum[] values;
            for (DailySalesValueEnum value : values = DailySalesValueEnum.values()) {
                if (!StringUtils.equals((CharSequence)value.getKey(), (CharSequence)key)) continue;
                return value;
            }
            return null;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

