/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.dto.TpmDistribClosePolicyDto;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.service.TpmDistribClosePolicyService;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.TpmDistribClosePolicyVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public abstract class DistribClosePolicyCommonService {
    private static final Logger log = LoggerFactory.getLogger(DistribClosePolicyCommonService.class);
    @Autowired(required=false)
    private TpmDistribClosePolicyService closePolicyService;

    public void paramVariable(CalculateDto calculate) {
        log.info("\u5206\u9500\u653f\u7b56\u8868\u67e5\u8be2\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr((Object)calculate));
        Validate.notBlank((CharSequence)calculate.getProductCode(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notNull((Object)calculate.getStartTimeOrDate(), (String)"\u6d3b\u52a8\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
    }

    private TpmDistribClosePolicyDto distributionGetValueParams(CalculateDto calculate, String type, String activityType) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        TpmDistribClosePolicyDto distributionClosePolicy = new TpmDistribClosePolicyDto();
        distributionClosePolicy.setProductCode(calculate.getProductCode());
        String customerErpCode = calculate.getCustomerErpCode();
        String salesOrganizationErpCode = calculate.getSalesOrganizationErpCode();
        String businessFormatCode = calculate.getBusinessFormatCode();
        String estoreCustomerLevel = calculate.getEstoreCustomerLevel();
        Date startTimeOrDate = calculate.getStartTimeOrDate();
        Date endTimeOrDate = calculate.getEndTimeOrDate();
        if (StringUtils.equals((CharSequence)DistributionClosePolicyActivityTypeEnum.Last_Basic_Rebate_Monthly_Return.getKey(), (CharSequence)activityType) || StringUtils.equals((CharSequence)DistributionClosePolicyActivityTypeEnum.LAST_BUNDLE_REBATES.getKey(), (CharSequence)activityType)) {
            startTimeOrDate = this.getLastMonthDay(startTimeOrDate);
            endTimeOrDate = this.getLastMonthDay(endTimeOrDate);
        }
        distributionClosePolicy.setStartDate(format.format(startTimeOrDate));
        distributionClosePolicy.setEndDate(format.format(endTimeOrDate));
        distributionClosePolicy.setProductCode(calculate.getProductCode());
        String channel = calculate.getChannel();
        if (StringUtils.isNotEmpty((CharSequence)customerErpCode) && StringUtils.isNotEmpty((CharSequence)salesOrganizationErpCode) && StringUtils.isNotEmpty((CharSequence)businessFormatCode) && StringUtils.isNotEmpty((CharSequence)channel) && StringUtils.equals((CharSequence)"first", (CharSequence)type)) {
            distributionClosePolicy.setCustomerErpCode(customerErpCode);
            distributionClosePolicy.setSalesInstitutionErpCode(salesOrganizationErpCode);
            distributionClosePolicy.setBusinessFormatCode(businessFormatCode);
            distributionClosePolicy.setChannelCode(channel);
            return distributionClosePolicy;
        }
        if (StringUtils.isNotEmpty((CharSequence)estoreCustomerLevel) && StringUtils.equals((CharSequence)"second", (CharSequence)type)) {
            distributionClosePolicy.setEstoreCustomerLevel(estoreCustomerLevel);
            return distributionClosePolicy;
        }
        return null;
    }

    public BigDecimal getDistributionClosurePolicy(CalculateDto calculate, String activityType) {
        BigDecimal resultValue = BigDecimal.ZERO;
        DistributionClosePolicyActivityTypeEnum activityTypeEnum = DistributionClosePolicyActivityTypeEnum.getActivityType(activityType);
        TpmDistribClosePolicyDto distributionClosePolicy = this.distributionGetValueParams(calculate, "first", activityType);
        if (ObjectUtil.isNull((Object)distributionClosePolicy)) {
            return BigDecimal.ZERO;
        }
        log.info("getDistributionClosurePolicy 1===>" + JSONObject.toJSONString((Object)distributionClosePolicy));
        List list = this.closePolicyService.findByCondition(distributionClosePolicy, calculate.getYearMonthLy());
        if (CollectionUtils.isEmpty((Collection)list)) {
            distributionClosePolicy = this.distributionGetValueParams(calculate, "second", activityType);
            if (ObjectUtil.isNull((Object)distributionClosePolicy)) {
                return BigDecimal.ZERO;
            }
            log.info("getDistributionClosurePolicy 2===>" + JSONObject.toJSONString((Object)distributionClosePolicy));
            list = this.closePolicyService.findByCondition(distributionClosePolicy, calculate.getYearMonthLy());
        }
        if (!CollectionUtils.isEmpty((Collection)list)) {
            TpmDistribClosePolicyVo distribClosePolicy = (TpmDistribClosePolicyVo)list.get(0);
            resultValue = this.getValue(distribClosePolicy, activityTypeEnum);
        }
        if (Objects.isNull(resultValue)) {
            return BigDecimal.ZERO;
        }
        return resultValue;
    }

    private BigDecimal getValue(TpmDistribClosePolicyVo closePolicy, DistributionClosePolicyActivityTypeEnum activityType) {
        BigDecimal resultValue = BigDecimal.ZERO;
        switch (activityType) {
            case Basic_Rebate_Ten_Return: {
                resultValue = closePolicy.getTenDayReturn();
                break;
            }
            case Basic_Rebate_Monthly_Return: {
                resultValue = closePolicy.getLunarReturn();
                break;
            }
            case Last_Basic_Rebate_Monthly_Return: {
                resultValue = closePolicy.getLunarReturn();
                break;
            }
            case MONTHLY_GOAL_RETURN: {
                resultValue = closePolicy.getMonthlyTargetReturn();
                break;
            }
            case LOT_PRICE_POLICY: {
                resultValue = closePolicy.getTakeHomePricePolicy();
                break;
            }
            case PERSONNEL_COSTS: {
                resultValue = closePolicy.getStaffCosts();
                break;
            }
            case DELIVERY_COSTS: {
                resultValue = closePolicy.getCostOfPlacement();
                break;
            }
            case LOGISTICS_SUPPORT: {
                resultValue = closePolicy.getLogisticsSupport();
                break;
            }
            case BUNDLE_REBATES: {
                resultValue = closePolicy.getBundleReturnPoint();
                break;
            }
            case LAST_BUNDLE_REBATES: {
                resultValue = closePolicy.getBundleReturnPoint();
                break;
            }
            case ADDITIONAL_SUPPORT: {
                resultValue = closePolicy.getOtherCooperation();
                break;
            }
            case ADDITIONAL_SUPPORT2: {
                resultValue = closePolicy.getOtherCooperationTwo();
                break;
            }
            case YEARLY_RETURN: {
                resultValue = closePolicy.getAnnualReturn();
                break;
            }
            case OTHER_SUPPORT_3: {
                resultValue = closePolicy.getOtherCooperationThree();
                break;
            }
            case OTHER_SUPPORT_4: {
                resultValue = closePolicy.getOtherCooperationFour();
                break;
            }
            case BASIC_REBATE_QUARTER_RETURN: {
                resultValue = closePolicy.getQuarterReturn();
                break;
            }
        }
        return resultValue;
    }

    public Date getLastMonthDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -1);
        return calendar.getTime();
    }

    public static enum DistributionClosePolicyActivityTypeEnum {
        Basic_Rebate_Ten_Return("basic_rebate_ten_return", "\u57fa\u7840\u8fd4\u70b9-\u65ec\u8fd4"),
        Basic_Rebate_Monthly_Return("basic_rebate_monthly_return", "\u57fa\u7840\u8fd4\u70b9-\u6708\u8fd4"),
        Last_Basic_Rebate_Monthly_Return("last_basic_rebate_monthly_return", "\u4e0a\u6708\u57fa\u7840\u8fd4\u70b9-\u6708\u8fd4"),
        MONTHLY_GOAL_RETURN("monthly_goal_return", "\u6708\u5ea6\u76ee\u6807\u8fd4"),
        LOT_PRICE_POLICY("lot_price_policy", "\u5230\u624b\u4ef7\u653f\u7b56"),
        PERSONNEL_COSTS("personnel_costs", "\u4eba\u5458\u8d39\u7528"),
        DELIVERY_COSTS("delivery_costs", "\u6295\u653e\u8d39\u7528"),
        LOGISTICS_SUPPORT("logistics_support", "\u7269\u6d41\u652f\u6301"),
        BUNDLE_REBATES("bundle_rebates", "\u6346\u7ed1\u8fd4\u70b9"),
        LAST_BUNDLE_REBATES("last_bundle_rebates", "\u6346\u7ed1\u8fd4\u70b9"),
        ADDITIONAL_SUPPORT("additional_support", "\u5176\u4ed6\u652f\u6301"),
        ADDITIONAL_SUPPORT2("additional_support2", "\u5176\u4ed6\u652f\u63012"),
        YEARLY_RETURN("yearly_return", "\u5e74\u8fd4"),
        OTHER_SUPPORT_3("other_support_3", "\u5176\u4ed6\u652f\u63013"),
        OTHER_SUPPORT_4("other_support_4", "\u5176\u4ed6\u652f\u63014"),
        BASIC_REBATE_QUARTER_RETURN("basic_rebate_quarter_return", "\u5b63\u8fd4");

        private String key;
        private String value;

        private DistributionClosePolicyActivityTypeEnum(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public static DistributionClosePolicyActivityTypeEnum getActivityType(String activityType) {
            DistributionClosePolicyActivityTypeEnum[] values;
            for (DistributionClosePolicyActivityTypeEnum value : values = DistributionClosePolicyActivityTypeEnum.values()) {
                if (!StringUtils.equals((CharSequence)value.getKey(), (CharSequence)activityType)) continue;
                return value;
            }
            return null;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

