/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import com.biz.crm.tpm.business.settlement.manage.sdk.dto.TpmSettlementManageDto;
import com.biz.crm.tpm.business.settlement.manage.sdk.enums.TpmSettlementActivityFormEnum;
import com.biz.crm.tpm.business.settlement.manage.sdk.service.TpmSettlementManageService;
import com.biz.crm.tpm.business.variable.local.register.ecommerce.EcommerceRegisterHelper;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JingBeansRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(JingBeansRegister.class);
    @Autowired(required=false)
    private EcommerceRegisterHelper ecommerceRegisterHelper;
    @Autowired(required=false)
    private TpmSettlementManageService tpmSettlementManageService;

    public String getVariableCode() {
        return "jingBeans";
    }

    public String getVariableName() {
        return "\u4eac\u8c46\uff08\u7535\u5546\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);
        return list;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notNull((Object)calculateDto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getYearMonthLy(), (String)"\u6d3b\u52a8\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        TpmSettlementManageDto dto = new TpmSettlementManageDto();
        dto.setCustomerCode(calculateDto.getCustomerCode());
        dto.setProductCode(calculateDto.getProductCode());
        dto.setYearMonthStr(calculateDto.getYearMonthLy());
        TpmSettlementActivityFormEnum activityFormEnum = TpmSettlementActivityFormEnum.findByCode((String)this.getVariableCode());
        Validate.notNull((Object)activityFormEnum, (String)"\u4e0d\u652f\u6301\u7684\u53d8\u91cf", (Object[])new Object[0]);
        dto.setActivityFormCode(activityFormEnum.getDesc());
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(4);
        resultMap.put(this.getVariableCode(), this.tpmSettlementManageService.getAmountByActivityFormCode(dto));
        return resultMap;
    }
}

