/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import cn.hutool.core.util.ObjectUtil;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.dto.TpmDistributionCustomerMonthSaleDto;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.service.TpmDistributionCustomerMonthSaleService;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.vo.TpmDistributionCustomerMonthSaleRespVo;
import com.biz.crm.tpm.business.variable.local.utils.BigDecimalUtils;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public abstract class MonthlySalesDistributionCommonService {
    private static final Logger log = LoggerFactory.getLogger(MonthlySalesDistributionCommonService.class);
    @Autowired(required=false)
    private TpmDistributionCustomerMonthSaleService distributionCustomerMonthSaleService;

    public void monthlySalesDistributionVariable(CalculateDto calculate, MonthlySalesDistributionAmountEnum monthlySalesDistributionAmountEnum) {
        Validate.notBlank((CharSequence)calculate.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculate.getCustomerErpCode(), (String)"\u5ba2\u6237MDG\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculate.getSalesOrganizationCode(), (String)"\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculate.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculate.getChannel(), (String)"\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        if (!StringUtils.equals((CharSequence)MonthlySalesDistributionAmountEnum.TOTAL_AMOUNT_MONTH.getKey(), (CharSequence)monthlySalesDistributionAmountEnum.getKey())) {
            Validate.notBlank((CharSequence)calculate.getProductCode(), (String)"\u4ea7\u54c1\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        }
        if (StringUtils.equals((CharSequence)MonthlySalesDistributionAmountEnum.TOTAL_AMOUNT_YEAR.getKey(), (CharSequence)monthlySalesDistributionAmountEnum.getKey())) {
            Validate.notBlank((CharSequence)calculate.getYearLy(), (String)"\u6d3b\u52a8\u5e74\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        } else {
            Validate.notBlank((CharSequence)calculate.getYearMonthLy(), (String)"\u6d3b\u52a8\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        }
    }

    public BigDecimal getMonthlySalesDistributionValue(CalculateDto calculate, MonthlySalesDistributionAmountEnum monthlySalesDistributionAmountEnum) {
        List list;
        BigDecimal resultValue = BigDecimal.ZERO;
        TpmDistributionCustomerMonthSaleDto distributionCustomerMonthSale = new TpmDistributionCustomerMonthSaleDto();
        distributionCustomerMonthSale.setCustomerCode(calculate.getCustomerErpCode());
        distributionCustomerMonthSale.setChannelCode(calculate.getChannel());
        distributionCustomerMonthSale.setBusinessFormatCode(calculate.getBusinessFormatCode());
        int length = calculate.getSalesOrganizationCode().length();
        distributionCustomerMonthSale.setSalesInstitutionCode(calculate.getSalesOrganizationCode().substring(length - 4, length));
        if (StringUtils.equals((CharSequence)MonthlySalesDistributionAmountEnum.TOTAL_AMOUNT_YEAR.getKey(), (CharSequence)monthlySalesDistributionAmountEnum.getKey())) {
            distributionCustomerMonthSale.setDistributionCustomerMonthSaleYearMonth(calculate.getYearLy());
        } else {
            distributionCustomerMonthSale.setDistributionCustomerMonthSaleYearMonth(calculate.getYearMonthLy());
        }
        if (!StringUtils.equals((CharSequence)MonthlySalesDistributionAmountEnum.TOTAL_AMOUNT_MONTH.getKey(), (CharSequence)monthlySalesDistributionAmountEnum.getKey())) {
            distributionCustomerMonthSale.setProductCode(calculate.getProductCode());
        }
        if (CollectionUtils.isEmpty((Collection)(list = this.distributionCustomerMonthSaleService.findCustomerMonthSalesByParams(distributionCustomerMonthSale)))) {
            return resultValue;
        }
        if (StringUtils.equals((CharSequence)MonthlySalesDistributionAmountEnum.TOTAL_AMOUNT_YEAR.getKey(), (CharSequence)monthlySalesDistributionAmountEnum.getKey())) {
            resultValue = list.stream().filter(customerMonthSale -> ObjectUtil.isNotNull((Object)customerMonthSale.getMonthSaleAmount())).map(TpmDistributionCustomerMonthSaleRespVo::getMonthSaleAmount).collect(Collectors.toList()).stream().reduce(BigDecimal.ZERO, (xva$0, xva$1) -> BigDecimalUtils.sum(xva$0, xva$1));
        } else {
            switch (monthlySalesDistributionAmountEnum) {
                case BASIC_SALES_AMOUNT: {
                    resultValue = list.stream().filter(customerMonthSale -> ObjectUtil.isNotNull((Object)customerMonthSale.getBasicSaleAmount())).map(TpmDistributionCustomerMonthSaleRespVo::getBasicSaleAmount).collect(Collectors.toList()).stream().reduce(BigDecimal.ZERO, (xva$0, xva$1) -> BigDecimalUtils.sum(xva$0, xva$1));
                    break;
                }
                case BIND_SALES_AMOUNT: {
                    resultValue = list.stream().filter(customerMonthSale -> ObjectUtil.isNotNull((Object)customerMonthSale.getBoundGiftSaleAmount())).map(TpmDistributionCustomerMonthSaleRespVo::getBoundGiftSaleAmount).collect(Collectors.toList()).stream().reduce(BigDecimal.ZERO, (xva$0, xva$1) -> BigDecimalUtils.sum(xva$0, xva$1));
                    break;
                }
                case TOTAL_AMOUNT_MONTH: {
                    resultValue = list.stream().filter(customerMonthSale -> ObjectUtil.isNotNull((Object)customerMonthSale.getMonthSaleAmount())).map(TpmDistributionCustomerMonthSaleRespVo::getMonthSaleAmount).collect(Collectors.toList()).stream().reduce(BigDecimal.ZERO, (xva$0, xva$1) -> BigDecimalUtils.sum(xva$0, xva$1));
                    break;
                }
                case AMOUNT_MONTH: {
                    resultValue = list.stream().filter(customerMonthSale -> ObjectUtil.isNotNull((Object)customerMonthSale.getMonthSaleAmount())).map(TpmDistributionCustomerMonthSaleRespVo::getMonthSaleAmount).collect(Collectors.toList()).stream().reduce(BigDecimal.ZERO, (xva$0, xva$1) -> BigDecimalUtils.sum(xva$0, xva$1));
                    break;
                }
                case CULLING_AMOUNT: {
                    resultValue = list.stream().filter(customerMonthSale -> ObjectUtil.isNotNull((Object)customerMonthSale.getRidSaleAmount())).map(TpmDistributionCustomerMonthSaleRespVo::getRidSaleAmount).collect(Collectors.toList()).stream().reduce(BigDecimal.ZERO, (xva$0, xva$1) -> BigDecimalUtils.sum(xva$0, xva$1));
                    break;
                }
                case CULLING_NUMBER: {
                    resultValue = list.stream().filter(customerMonthSale -> ObjectUtil.isNotNull((Object)customerMonthSale.getRidSaleQuantity())).map(TpmDistributionCustomerMonthSaleRespVo::getRidSaleQuantity).collect(Collectors.toList()).stream().reduce(BigDecimal.ZERO, (xva$0, xva$1) -> BigDecimalUtils.sum(xva$0, xva$1));
                    break;
                }
            }
        }
        return resultValue;
    }

    public static enum MonthlySalesDistributionAmountEnum {
        BASIC_SALES_AMOUNT("basic_sales_amount", "\u57fa\u7840\u9500\u552e\u91d1\u989d"),
        BIND_SALES_AMOUNT("bind_sales_amount", "\u6346\u8d60\u9500\u552e\u91d1\u989d"),
        TOTAL_AMOUNT_MONTH("total_amount_month", "\u7d2f\u8ba1\u603b\u9500\u552e\u91d1\u989d"),
        AMOUNT_MONTH("amount_month", "\u603b\u9500\u552e\u91d1\u989d"),
        TOTAL_AMOUNT_YEAR("total_amount_year", "\u7d2f\u8ba1\u9500\u552e\u91d1\u989d\u6574\u5e74"),
        CULLING_AMOUNT("culling_amount", "\u5254\u91cf\u91d1\u989d"),
        CULLING_NUMBER("culling_number", "\u5254\u91cf\u6570\u91cf");

        private String key;
        private String desc;

        private MonthlySalesDistributionAmountEnum(String key, String desc) {
            this.key = key;
            this.desc = desc;
        }

        public MonthlySalesDistributionAmountEnum getMonthlySalesDistributionByKey(String key) {
            MonthlySalesDistributionAmountEnum[] values;
            for (MonthlySalesDistributionAmountEnum value : values = MonthlySalesDistributionAmountEnum.values()) {
                if (!StringUtils.equals((CharSequence)value.getKey(), (CharSequence)key)) continue;
                return value;
            }
            return null;
        }

        public String getKey() {
            return this.key;
        }

        public String getDesc() {
            return this.desc;
        }
    }
}

