/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import com.biz.crm.tpm.business.day.sales.sdk.dto.TpmDaySalesSearchDto;
import com.biz.crm.tpm.business.day.sales.sdk.dto.TpmDaySalesSpliceSearchDto;
import com.biz.crm.tpm.business.day.sales.sdk.service.TpmDaySalesService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PlatformMonthlySalesRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(PlatformMonthlySalesRegister.class);
    @Autowired(required=false)
    private TpmDaySalesService daySalesService;

    public String getVariableCode() {
        return "platformMonthlySales";
    }

    public String getVariableName() {
        return "\u5e73\u53f0\u6708\u5ea6\u9500\u552e\uff08\u7535\u5546\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WARNING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WITHHOLDING);
        return list;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notNull((Object)calculateDto.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getStartTimeOrDate(), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getEndTimeOrDate(), (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        TpmDaySalesSpliceSearchDto daySalesSearch = new TpmDaySalesSpliceSearchDto();
        daySalesSearch.setCustomer(calculateDto.getCustomerCode());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            daySalesSearch.setStartDate(format.parse(format.format(calculateDto.getStartTimeOrDate())));
            daySalesSearch.setEndDate(format.parse(format.format(calculateDto.getEndTimeOrDate())));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        BigDecimal daySalesTotalAmount = this.daySalesService.getDaySalesTotalAmount((TpmDaySalesSearchDto)daySalesSearch);
        HashMap resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), daySalesTotalAmount);
        return resultMap;
    }
}

