/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import com.biz.crm.tpm.business.promotion.plan.sdk.service.GeneralExpensesService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.GeneralExpensesVo;
import com.biz.crm.tpm.business.variable.local.utils.DateUtils;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.service.TpmWithholdingDetailService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public abstract class PromotionPlanCommonService {
    private static final Logger log = LoggerFactory.getLogger(PromotionPlanCommonService.class);
    @Autowired(required=false)
    private PromotionPlanService promotionPlanService;
    @Autowired(required=false)
    private GeneralExpensesService generalExpensesService;
    @Autowired(required=false)
    private TpmWithholdingDetailService withholdingDetailService;

    public void promotionPlanValidate(CalculateDto calculate) {
        Validate.notBlank((CharSequence)calculate.getDetailPlanItemCode(), (String)"\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    public BigDecimal getPromotionPlanValue(CalculateDto calculate, GeneralExpensesEnum generalExpensesEnum) {
        if (StringUtils.equals((CharSequence)generalExpensesEnum.getKey(), (CharSequence)GeneralExpensesEnum.ACTIVITY_ACTUAL_DAY.getKey())) {
            Validate.notNull((Object)calculate.getWithHoldDate(), (String)"\u9884\u63d0\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        BigDecimal resultValue = BigDecimal.ZERO;
        String detailPlanItemCode = calculate.getDetailPlanItemCode();
        ArrayList codes = Lists.newArrayList();
        codes.add(detailPlanItemCode);
        List resultList = this.generalExpensesService.findByExpensesCode((List)codes);
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return resultValue;
        }
        GeneralExpensesVo generalExpensesVo = (GeneralExpensesVo)resultList.get(0);
        switch (generalExpensesEnum) {
            case ACTIVITY_END_DATE: {
                Date endDate = generalExpensesVo.getEndDate();
                LocalDate localDate = DateUtils.date2LocalDate(endDate);
                resultValue = new BigDecimal(localDate.getDayOfMonth());
                break;
            }
            case ACTIVITY_APPLY_AMOUNT: {
                resultValue = generalExpensesVo.getApplyAmount();
                break;
            }
            case ACTIVITY_ACTUAL_DAY: {
                resultValue = this.withholdingDate(generalExpensesVo, calculate.getWithHoldDate());
                break;
            }
            case ACTIVITY_TOTAL_DAY: {
                Date startDate = generalExpensesVo.getStartDate();
                Date endDate1 = generalExpensesVo.getEndDate();
                Integer day = DateUtils.timeDifferDay(DateUtils.date2LocalDateTime(startDate), DateUtils.date2LocalDateTime(endDate1));
                resultValue = new BigDecimal(day);
                break;
            }
        }
        return resultValue;
    }

    private BigDecimal withholdingDate(GeneralExpensesVo generalExpensesVo, Date withHole) {
        BigDecimal resultDay;
        Date endDate1 = generalExpensesVo.getEndDate();
        if (withHole.before(endDate1)) {
            Date startDate = generalExpensesVo.getStartDate();
            LocalDateTime startDateLocalDateTime = DateUtils.date2LocalDateTime(startDate);
            LocalDateTime createTimeLocalDateTime = DateUtils.date2LocalDateTime(withHole);
            Integer day = DateUtils.timeDifferDay(startDateLocalDateTime, createTimeLocalDateTime);
            resultDay = new BigDecimal(day);
        } else {
            Date beginDate = generalExpensesVo.getStartDate();
            Date endDate = generalExpensesVo.getEndDate();
            LocalDateTime beginLocalDateTime = DateUtils.date2LocalDateTime(beginDate);
            LocalDateTime endLocalDateTime = DateUtils.date2LocalDateTime(endDate);
            Integer day = DateUtils.timeDifferDay(beginLocalDateTime, endLocalDateTime);
            resultDay = new BigDecimal(day);
        }
        return resultDay;
    }

    public static enum GeneralExpensesEnum {
        ACTIVITY_END_DATE("activity_end_date", "\u6d3b\u52a8\u7ed3\u675f\u65e5\u671f"),
        ACTIVITY_APPLY_AMOUNT("activity_apply_amount", "\u7535\u5546\u6d3b\u52a8\u7533\u8bf7\u91d1\u989d"),
        ACTIVITY_ACTUAL_DAY("activity_actual_day", "\u6d3b\u52a8\u5b9e\u9645\u5929\u6570"),
        ACTIVITY_TOTAL_DAY("activity_total_day", "\u6d3b\u52a8\u603b\u5929\u6570");

        private String key;
        private String desc;

        private GeneralExpensesEnum(String key, String desc) {
            this.key = key;
            this.desc = desc;
        }

        public String getKey() {
            return this.key;
        }

        public String getDesc() {
            return this.desc;
        }
    }
}

