/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import com.biz.crm.tpm.business.settlement.manage.sdk.dto.TpmSettlementManageDto;
import com.biz.crm.tpm.business.settlement.manage.sdk.service.TpmSettlementManageService;
import com.biz.crm.tpm.business.variable.local.register.ecommerce.EcommerceRegisterHelper;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SelfScreeningKickbackRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(SelfScreeningKickbackRegister.class);
    @Autowired(required=false)
    private EcommerceRegisterHelper ecommerceRegisterHelper;
    @Autowired(required=false)
    private TpmSettlementManageService tpmSettlementManageService;

    public String getVariableCode() {
        return "selfScreeningKickback";
    }

    public String getVariableName() {
        return "\u81ea\u64ad\u4f63\u91d1\uff08\u7535\u5546\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);
        return list;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        TpmSettlementManageDto dto = this.ecommerceRegisterHelper.buildTpmSettlementManageDto(calculateDto);
        BigDecimal amount = this.tpmSettlementManageService.getAmountByActivityFormCode(dto);
        HashMap resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), amount);
        return resultMap;
    }
}

