/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import com.biz.crm.tpm.business.settlement.manage.sdk.dto.TpmSettlementManageDto;
import com.biz.crm.tpm.business.settlement.manage.sdk.service.TpmSettlementManageService;
import com.biz.crm.tpm.business.variable.local.utils.DateUtils;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public abstract class SettlementManageCommonService {
    private static final Logger log = LoggerFactory.getLogger(SettlementManageCommonService.class);
    @Autowired(required=false)
    private TpmSettlementManageService settlementManageService;

    public void settlementManageValidate(CalculateDto calculate) {
        Validate.notBlank((CharSequence)calculate.getCustomerErpCode(), (String)"\u5ba2\u6237MGB\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculate.getSalesOrganizationCode(), (String)"\u9500\u552e\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculate.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculate.getChannel(), (String)"\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculate.getYearMonthLy(), (String)"\u6d3b\u52a8\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculate.getActivityFormCode(), (String)"\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    public BigDecimal getSettlementManageValue(CalculateDto calculate) {
        String customerCode = calculate.getCustomerErpCode() + calculate.getSalesOrganizationCode() + calculate.getChannel() + calculate.getBusinessFormatCode();
        TpmSettlementManageDto settlementManage = new TpmSettlementManageDto();
        settlementManage.setCustomerCode(customerCode);
        settlementManage.setProductCode(calculate.getProductCode());
        settlementManage.setActivityFormCode(calculate.getActivityFormCode());
        String yearMonthLy = calculate.getYearMonthLy();
        boolean flag = yearMonthLy.contains("-");
        String strYearMonthLy = "";
        strYearMonthLy = flag ? yearMonthLy.substring(0, 4) + yearMonthLy.substring(6) : yearMonthLy;
        LocalDate date = LocalDate.parse(strYearMonthLy + "01", DateTimeFormatter.BASIC_ISO_DATE);
        LocalDate dateFirst = date.with(TemporalAdjusters.firstDayOfMonth());
        LocalDate dateEnd = date.with(TemporalAdjusters.lastDayOfMonth());
        settlementManage.setBusinessStartTime(DateUtils.localDate2Date(dateFirst));
        settlementManage.setBusinessEndTime(DateUtils.localDate2Date(dateEnd));
        return this.settlementManageService.getAmount(settlementManage);
    }
}

