/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.estore;

import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EDistributionMonthlySalesTargetRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(EDistributionMonthlySalesTargetRegister.class);
    @Autowired(required=false)
    private SalesGoalService salesGoalService;

    public String getVariableCode() {
        return "eDistributionMonthlySalesTarget";
    }

    public String getVariableName() {
        return "\u5206\u9500\u6708\u5ea6\u9500\u552e\u76ee\u6807\uff08\u7535\u5546\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);
        return list;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank((CharSequence)calculateDto.getCustomerErpCode(), (String)"\u5ba2\u6237MDG\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getSalesOrganizationCode(), (String)"\u9500\u552e\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getChannel(), (String)"\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getYearMonthLy(), (String)"\u6d3b\u52a8\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        SalesGoalDto salesGoalDto = new SalesGoalDto();
        salesGoalDto.setCustomerErpCode(calculateDto.getCustomerErpCode());
        salesGoalDto.setSalesInstitutionCode(calculateDto.getSalesOrganizationCode());
        salesGoalDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        salesGoalDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        salesGoalDto.setChannelCode(calculateDto.getChannel());
        salesGoalDto.setYearMonthLy(calculateDto.getYearMonthLy());
        List salesGoalVos = this.salesGoalService.listForVariableCal(salesGoalDto);
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (CollectionUtils.isEmpty((Collection)salesGoalVos)) {
            return resultMap;
        }
        resultMap.put(this.getVariableCode(), salesGoalVos.stream().filter(e -> Objects.nonNull(e.getDeliverySalesAmount())).map(SalesGoalVo::getDeliverySalesAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        return resultMap;
    }
}

