/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.estore;

import com.biz.crm.tpm.business.distrib.close.policy.sdk.dto.TpmDistribClosePolicyDto;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.service.TpmDistribClosePolicyService;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.TpmDistribClosePolicyVo;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.dto.TpmDistributionCustomerMonthSaleDto;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.service.TpmDistributionCustomerMonthSaleService;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.vo.TpmDistributionCustomerMonthSaleRespVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EDistributionPersonPolicyAmountRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(EDistributionPersonPolicyAmountRegister.class);
    @Autowired(required=false)
    private TpmDistribClosePolicyService tpmDistribClosePolicyService;
    @Autowired(required=false)
    private TpmDistributionCustomerMonthSaleService tpmDistributionCustomerMonthSaleService;

    public String getVariableCode() {
        return "eDistributionPersonPolicyAmount";
    }

    public String getVariableName() {
        return "\u5206\u9500\u4eba\u5458\u653f\u7b56\u603b\u989d\uff08\u7535\u5546\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);
        return list;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank((CharSequence)calculateDto.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getCustomerErpCode(), (String)"\u5ba2\u6237MDG\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getSalesOrganizationCode(), (String)"\u9500\u552e\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getChannel(), (String)"\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getYearMonthLy(), (String)"\u6d3b\u52a8\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getEstoreCustomerLevel(), (String)"\u7535\u5546\u5ba2\u6237\u7b49\u7ea7\u7f16\u7801\uff01", (Object[])new Object[0]);
        TpmDistributionCustomerMonthSaleDto dto = new TpmDistributionCustomerMonthSaleDto();
        dto.setCustomerCode(calculateDto.getCustomerErpCode());
        dto.setSalesInstitutionCode(calculateDto.getSalesOrganizationErpCode());
        dto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        dto.setChannelCode(calculateDto.getChannel());
        dto.setDistributionCustomerMonthSaleYearMonth(calculateDto.getYearMonthLy());
        List saleRespVos = this.tpmDistributionCustomerMonthSaleService.listForVariable(dto, "month");
        Map<String, List<TpmDistributionCustomerMonthSaleRespVo>> saleMap = saleRespVos.stream().collect(Collectors.groupingBy(TpmDistributionCustomerMonthSaleRespVo::getProductCode));
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (Map.Entry<String, List<TpmDistributionCustomerMonthSaleRespVo>> entry : saleMap.entrySet()) {
            String product = entry.getKey();
            List<TpmDistributionCustomerMonthSaleRespVo> list = entry.getValue();
            TpmDistribClosePolicyDto policyDto = new TpmDistribClosePolicyDto();
            policyDto.setCustomerCode(calculateDto.getCustomerCode());
            policyDto.setProductCode(product);
            policyDto.setStartDate(calculateDto.getYearMonthLy() + "-01");
            List policyVos = this.tpmDistribClosePolicyService.findDistribClosePolicy(policyDto);
            if (CollectionUtils.isEmpty((Collection)policyVos)) {
                policyDto.setEstoreCustomerLevel(calculateDto.getEstoreCustomerLevel());
                policyDto.setCustomerCode(null);
                policyVos = this.tpmDistribClosePolicyService.findDistribClosePolicy(policyDto);
            }
            BigDecimal staffCosts = BigDecimal.ZERO;
            if (!CollectionUtils.isEmpty((Collection)policyVos)) {
                staffCosts = ((TpmDistribClosePolicyVo)policyVos.get(0)).getStaffCosts();
            }
            BigDecimal monthAmount = BigDecimal.ZERO;
            BigDecimal manualAuditSaleAmount = BigDecimal.ZERO;
            if (!CollectionUtils.isEmpty((Collection)saleRespVos)) {
                monthAmount = list.stream().filter(e -> Objects.nonNull(e.getMonthSaleAmount())).map(TpmDistributionCustomerMonthSaleRespVo::getMonthSaleAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                manualAuditSaleAmount = list.stream().filter(e -> Objects.nonNull(e.getManualAuditSaleAmount())).map(TpmDistributionCustomerMonthSaleRespVo::getManualAuditSaleAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            BigDecimal amt = Optional.ofNullable(monthAmount).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(manualAuditSaleAmount).orElse(BigDecimal.ZERO));
            amt = amt.multiply(Optional.ofNullable(staffCosts).orElse(BigDecimal.ZERO));
            totalAmount = totalAmount.add(amt);
        }
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        resultMap.put(this.getVariableCode(), totalAmount);
        return resultMap;
    }
}

