/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.estore;

import com.biz.crm.tpm.business.distribution.wages.sdk.dto.DistributionWagesDto;
import com.biz.crm.tpm.business.distribution.wages.sdk.service.DistributionWagesService;
import com.biz.crm.tpm.business.distribution.wages.sdk.vo.DistributionWagesVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EDistributionPersonWagesAmountRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(EDistributionPersonWagesAmountRegister.class);
    @Autowired(required=false)
    private DistributionWagesService distributionWagesService;

    public String getVariableCode() {
        return "eDistributionPersonWagesAmount";
    }

    public String getVariableName() {
        return "\u5206\u9500\u4eba\u5458\u5de5\u8d44\u603b\u989d\uff08\u7535\u5546\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);
        return list;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank((CharSequence)calculateDto.getCustomerErpCode(), (String)"\u5ba2\u6237MDG\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getYearMonthLy(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DistributionWagesDto distributionWagesDto = new DistributionWagesDto();
        distributionWagesDto.setCustomerCode(calculateDto.getCustomerErpCode());
        distributionWagesDto.setYears(calculateDto.getYearMonthLy());
        List voList = this.distributionWagesService.findForVariable(distributionWagesDto);
        HashMap resultMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty((Collection)voList)) {
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
            return resultMap;
        }
        resultMap.put(this.getVariableCode(), voList.stream().filter(e -> Objects.nonNull(e.getSalaryAmount())).map(DistributionWagesVo::getSalaryAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        return resultMap;
    }
}

