/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.estore;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.PriceTypeEnum;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.biz.crm.tpm.business.variable.local.register.common.PriceRegisterParamBuilder;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EPlatformSupplyPriceVariableRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(EPlatformSupplyPriceVariableRegister.class);
    @Autowired(required=false)
    private PriceModelVoService priceModelVoService;

    public String getVariableCode() {
        return "ePlatformSupplyPriceVariable";
    }

    public String getVariableName() {
        return "\u5e73\u53f0\u4f9b\u8d27\u4ef7\uff08\u5143\uff09\uff08\u7535\u5546\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        return list;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank((CharSequence)calculateDto.getCustomerErpCode(), (String)"\u5ba2\u6237MDG\u7f16\u7801\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getProductCode(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getSalesOrgErpCode(), (String)"\u9500\u552e\u7ec4\u7ec7\u77ed\u7801\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getStartTimeOrDate(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        calculateDto.setSearchTime(calculateDto.getStartTimeOrDate());
        SearchPriceDto searchPrice = PriceRegisterParamBuilder.buildParam(calculateDto, PriceTypeEnum.ZDS1);
        log.info("========================================\u5e73\u53f0\u4f9b\u8d27\u4ef7\uff08\u5143\uff09\uff08\u7535\u5546\uff09\u8c03\u7528\u4ef7\u683c\u53c2\u6570\uff1a" + JSONObject.toJSONString((Object)searchPrice));
        Map priceModelVoMap = this.priceModelVoService.handleSearchPrice(searchPrice);
        BigDecimal resultPrice = BigDecimal.ZERO;
        if (Objects.nonNull(priceModelVoMap)) {
            for (Map.Entry entry : priceModelVoMap.entrySet()) {
                PriceModelVo value = (PriceModelVo)entry.getValue();
                BigDecimal price = value.getPrice();
                if (Objects.isNull(price)) continue;
                resultPrice = price;
                break;
            }
        }
        log.info("========================================\u5e73\u53f0\u4f9b\u8d27\u4ef7\uff08\u5143\uff09\uff08\u7535\u5546\uff09\u8c03\u7528\u4ef7\u683c\u7ed3\u679c\uff1a" + JSONObject.toJSONString((Object)priceModelVoMap));
        HashMap resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), resultPrice);
        return resultMap;
    }
}

