/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.estore;

import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EYearSalesTargetRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(EYearSalesTargetRegister.class);
    @Autowired(required=false)
    private SalesGoalService salesGoalService;

    public String getVariableCode() {
        return "eYearSalesTarget";
    }

    public String getVariableName() {
        return "\u5e74\u5ea6\u9500\u552e\u76ee\u6807\uff08\u7535\u5546\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);
        return list;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank((CharSequence)calculateDto.getSalesOrganizationCode(), (String)"\u9500\u552e\u673a\u6784\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getChannel(), (String)"\u6e20\u9053\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getCustomerErpCode(), (String)"\u5ba2\u6237MDG\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getYearMonthLy(), (String)"\u5e74\u6708\u4e3a\u7a7a", (Object[])new Object[0]);
        SalesGoalDto salesGoalDto = new SalesGoalDto();
        salesGoalDto.setSalesInstitutionCode(calculateDto.getSalesOrganizationCode());
        salesGoalDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        salesGoalDto.setChannelCode(calculateDto.getChannel());
        salesGoalDto.setCustomerErpCode(calculateDto.getCustomerErpCode());
        salesGoalDto.setYearMonthLy(calculateDto.getYearMonthLy());
        List vos = this.salesGoalService.listForVariableCalNew(salesGoalDto);
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (CollectionUtils.isEmpty((Collection)vos)) {
            return resultMap;
        }
        BigDecimal total = vos.stream().filter(e -> Objects.nonNull(e.getDeliverySalesAmount())).map(SalesGoalVo::getDeliverySalesAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        resultMap.put(this.getVariableCode(), total);
        return resultMap;
    }
}

