/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.estore;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.tpm.business.audit.business.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class WhetherTrySalesRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(WhetherTrySalesRegister.class);
    @Autowired(required=false)
    private CustomerVoService customerVoService;

    public String getVariableCode() {
        return "whetherTrySales";
    }

    public String getVariableName() {
        return "\u662f\u5426\u8bd5\u9500\u671f\uff08\u7535\u5546\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);
        return list;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank((CharSequence)calculateDto.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getCustomerErpCode(), (String)"\u5ba2\u6237MDG\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getSalesOrganizationCode(), (String)"\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getChannel(), (String)"\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        ArrayList<String> customerCodes = new ArrayList<String>();
        customerCodes.add(calculateDto.getCustomerCode());
        List customerVoList = this.customerVoService.findBaseByCustomerCodes(customerCodes);
        log.info("\u662f\u5426\u8bd5\u9500\u671f=====>{}", JSONObject.toJSON((Object)customerVoList));
        HashMap resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (CollectionUtils.isEmpty((Collection)customerVoList)) {
            return resultMap;
        }
        if (!CollectionUtils.isEmpty(customerVoList = customerVoList.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getIsTestMarket())).collect(Collectors.toList()))) {
            String isTestMarket = ((CustomerVo)customerVoList.get(0)).getIsTestMarket();
            resultMap.put(this.getVariableCode(), YesOrNoEnum.YES.getCode().equals(isTestMarket) ? BigDecimal.ONE : BigDecimal.ZERO);
        }
        return resultMap;
    }
}

