/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.estore.common;

import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.dto.TpmDistributionCustomerAuditDataImportDto;
import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.service.TpmDistributionCustomerAuditDataService;
import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.vo.TpmDistributionCustomerAuditDataRespVo;
import com.biz.crm.tpm.business.variable.local.register.common.VariablePropertyValueHelper;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TpmDistributionCustomerAuditDataHelper {
    @Autowired(required=false)
    private TpmDistributionCustomerAuditDataService tpmDistributionCustomerAuditDataService;

    public void valParam(CalculateDto calculateDto) {
        Validate.notBlank((CharSequence)calculateDto.getCustomerErpCode(), (String)"\u5ba2\u6237MDG\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getProductCode(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getYearMonthLy(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    public BigDecimal getValue(CalculateDto calculateDto, String propertyName) {
        TpmDistributionCustomerAuditDataImportDto dto = new TpmDistributionCustomerAuditDataImportDto();
        dto.setCustomerCode(calculateDto.getCustomerErpCode());
        dto.setDistributionCustomerAuditYearMonth(calculateDto.getYearMonthLy());
        dto.setProductCode(calculateDto.getProductCode());
        List respVos = this.tpmDistributionCustomerAuditDataService.listForVariable(dto);
        BigDecimal value = BigDecimal.ZERO;
        if (CollectionUtils.isEmpty((Collection)respVos)) {
            return value;
        }
        for (TpmDistributionCustomerAuditDataRespVo respVo : respVos) {
            BigDecimal v = VariablePropertyValueHelper.getValue(TpmDistributionCustomerAuditDataRespVo.class, propertyName, respVo);
            value = value.add(v);
        }
        return value;
    }
}

