/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.estore.common;

import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.dto.TpmDistributionCustomerMonthSaleDto;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.service.TpmDistributionCustomerMonthSaleService;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.vo.TpmDistributionCustomerMonthSaleRespVo;
import com.biz.crm.tpm.business.variable.local.register.common.VariablePropertyValueHelper;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TpmDistributionCustomerSalesDataHelper {
    public static final String YEAR = "year";
    public static final String MONTH = "month";
    @Autowired(required=false)
    private TpmDistributionCustomerMonthSaleService tpmDistributionCustomerMonthSaleService;

    public void val(CalculateDto calculateDto) {
        Validate.notBlank((CharSequence)calculateDto.getCustomerErpCode(), (String)"\u5ba2\u6237MDG\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getSalesOrganizationCode(), (String)"\u9500\u552e\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getChannel(), (String)"\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getYearMonthLy(), (String)"\u6d3b\u52a8\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getProductCode(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    public BigDecimal getValue(CalculateDto calculateDto, String propertyName, String yearMonthType) {
        TpmDistributionCustomerMonthSaleDto dto = new TpmDistributionCustomerMonthSaleDto();
        dto.setCustomerCode(calculateDto.getCustomerErpCode());
        int length = calculateDto.getSalesOrganizationCode().length();
        dto.setSalesInstitutionCode(calculateDto.getSalesOrganizationCode().substring(length - 4, length));
        dto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        dto.setChannelCode(calculateDto.getChannel());
        dto.setDistributionCustomerMonthSaleYearMonth(calculateDto.getYearMonthLy());
        dto.setProductCode(calculateDto.getProductCode());
        List vos = this.tpmDistributionCustomerMonthSaleService.listForVariable(dto, yearMonthType);
        BigDecimal value = BigDecimal.ZERO;
        if (CollectionUtils.isEmpty((Collection)vos)) {
            return value;
        }
        for (TpmDistributionCustomerMonthSaleRespVo respVo : vos) {
            BigDecimal v = VariablePropertyValueHelper.getValue(TpmDistributionCustomerMonthSaleRespVo.class, propertyName, respVo);
            value = value.add(v);
        }
        return value;
    }
}

