/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.estore.common;

import com.biz.crm.tpm.business.platform.rebate.order.sdk.dto.TpmPlatformRebateOrderDto;
import com.biz.crm.tpm.business.platform.rebate.order.sdk.service.TpmPlatformRebateOrderSdkService;
import com.biz.crm.tpm.business.platform.rebate.order.sdk.vo.TpmPlatformRebateOrderVo;
import com.biz.crm.tpm.business.variable.local.register.common.VariablePropertyValueHelper;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TpmPlatformRebateOrderDataHelper {
    @Autowired(required=false)
    private TpmPlatformRebateOrderSdkService tpmPlatformRebateOrderSdkService;

    public void valParam(CalculateDto calculateDto) {
        Validate.notBlank((CharSequence)calculateDto.getCustomerErpCode(), (String)"\u5ba2\u6237MDG\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getProductCode(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getYearMonthLy(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    public BigDecimal getValue(CalculateDto calculateDto, String propertyName) {
        TpmPlatformRebateOrderDto dto = new TpmPlatformRebateOrderDto();
        dto.setCustomerCode(calculateDto.getCustomerErpCode());
        dto.setYearMonthLy(calculateDto.getYearMonthLy());
        dto.setIncludeSapProductCodeList(Arrays.asList(calculateDto.getProductCode().split(",")));
        List respVos = this.tpmPlatformRebateOrderSdkService.listForVariable(dto);
        BigDecimal value = BigDecimal.ZERO;
        if (CollectionUtils.isEmpty((Collection)respVos)) {
            return value;
        }
        for (TpmPlatformRebateOrderVo respVo : respVos) {
            BigDecimal v = VariablePropertyValueHelper.getValue(TpmPlatformRebateOrderVo.class, propertyName, respVo);
            value = value.add(v);
        }
        return value;
    }
}

