/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.mainstay;

import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ActivityIntensityRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(ActivityIntensityRegister.class);
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    public String getVariableCode() {
        return "activityIntensity";
    }

    public String getVariableName() {
        return "\u6d3b\u52a8\u529b\u5ea6\uff08\u4e3b\u4f53\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank((CharSequence)calculateDto.getDetailPlanItemCode(), (String)"\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(1);
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        List vos = this.activityDetailPlanItemSdkService.listByItemCodeList((List)Lists.newArrayList((Object[])new String[]{calculateDto.getDetailPlanItemCode()}));
        if (CollectionUtils.isEmpty((Collection)vos)) {
            return resultMap;
        }
        String activityIntensityStr = ((ActivityDetailPlanItemVo)vos.get(0)).getActivityIntensity();
        if (StringUtils.isEmpty((CharSequence)activityIntensityStr)) {
            return resultMap;
        }
        BigDecimal activityIntensity = BigDecimal.ZERO;
        if (activityIntensityStr.contains("/")) {
            BigDecimal var2;
            BigDecimal var1;
            String[] vars = activityIntensityStr.split("/");
            Validate.isTrue((vars.length == 2 ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u529b\u5ea6[%s]\u683c\u5f0f\u9519\u8bef\uff01", (Object[])new Object[]{activityIntensityStr});
            try {
                var1 = new BigDecimal(vars[0]);
                var2 = new BigDecimal(vars[1]);
            }
            catch (Exception e) {
                throw new RuntimeException("\u6d3b\u52a8\u529b\u5ea6[" + activityIntensityStr + "]\u683c\u5f0f\u9519\u8bef\uff01");
            }
            Validate.isTrue((var2.compareTo(BigDecimal.ZERO) != 0 ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u529b\u5ea6[%s]\u5206\u5b50\u4e0d\u80fd\u4e3a0\uff01", (Object[])new Object[]{activityIntensityStr});
            activityIntensity = var1.divide(var2, 8, RoundingMode.HALF_UP);
        } else {
            try {
                activityIntensity = new BigDecimal(activityIntensityStr).setScale(8, RoundingMode.HALF_UP);
            }
            catch (Exception e) {
                throw new RuntimeException("\u6d3b\u52a8\u529b\u5ea6[" + activityIntensityStr + "]\u683c\u5f0f\u9519\u8bef\uff01");
            }
        }
        resultMap.put(this.getVariableCode(), activityIntensity);
        return resultMap;
    }
}

