/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.mainstay;

import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.dto.MainOnedaySalesDataDto;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.service.MainOnedaySaleDataService;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.vo.MainOnedaySalesDataVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ActivityPeriodProductDiscountSalesAmountToBMilkRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(ActivityPeriodProductDiscountSalesAmountToBMilkRegister.class);
    @Autowired(required=false)
    private MainOnedaySaleDataService mainOnedaySaleDataService;

    public String getVariableCode() {
        return "activityPeriodProductDiscountSalesAmountToBMilk";
    }

    public String getVariableName() {
        return "\u6d3b\u52a8\u671f\u95f4\u53ca\u6d3b\u52a8\u4ea7\u54c1\u6298\u540e\u9500\u552e\u989d\uff082B\u5976\u5361\uff09\uff08\u4e3b\u4f53\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        MainOnedaySalesDataDto salesDataDto = new MainOnedaySalesDataDto();
        Validate.notBlank((CharSequence)calculateDto.getYearMonthLy(), (String)"\u5e74\u6708\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        salesDataDto.setYearMonthLy(calculateDto.getYearMonthLy().replaceAll("-", ""));
        salesDataDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        salesDataDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        if (!CollectionUtils.isEmpty((Collection)calculateDto.getCustomerCodeList())) {
            salesDataDto.setCustomerCodeList((List)Lists.newArrayList((Iterable)calculateDto.getCustomerCodeList()));
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getSalesGroupCode())) {
            salesDataDto.setSalesOrgProvinceCode(calculateDto.getSalesGroupCode());
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getSalesRegionCode())) {
            salesDataDto.setSalesOrgRegionCode(calculateDto.getSalesRegionCode());
        } else {
            throw new RuntimeException("\u5ba2\u6237\u7f16\u7801\u3001\u9500\u552e\u7ec4\u3001\u9500\u552e\u90e8\u95e8\u5168\u90e8\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((CharSequence)calculateDto.getProductCode())) {
            salesDataDto.setProductCodes(Arrays.asList(calculateDto.getProductCode().split(",")));
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getItemCode())) {
            salesDataDto.setProductItemCode(calculateDto.getItemCode());
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getCategoryCode())) {
            salesDataDto.setProductCategoryCode(calculateDto.getCategoryCode());
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getBrandCode()) && !StringUtils.equals((CharSequence)"130000", (CharSequence)calculateDto.getBrandCode())) {
            salesDataDto.setProductBrandCode(calculateDto.getBrandCode());
        }
        List salesDataVos = this.mainOnedaySaleDataService.listMainOnedaySalesData(salesDataDto);
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(1);
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (CollectionUtils.isEmpty((Collection)salesDataVos)) {
            return resultMap;
        }
        BigDecimal total = salesDataVos.stream().filter(e -> Objects.nonNull(e.getMilkCardDiscountBehindOrderAmountToB())).map(MainOnedaySalesDataVo::getMilkCardDiscountBehindOrderAmountToB).reduce(BigDecimal.ZERO, BigDecimal::add);
        resultMap.put(this.getVariableCode(), total);
        return resultMap;
    }
}

