/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.mainstay;

import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import com.biz.crm.tpm.business.variable.local.register.configure.common.ConVariableRegisterParamHandler;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AllMonthProductDiscountTaskExcludeAmountRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(AllMonthProductDiscountTaskExcludeAmountRegister.class);
    @Autowired(required=false)
    private ConVariableRegisterParamHandler conVariableRegisterParamHandler;

    public String getVariableCode() {
        return "allMonthProductDiscountTaskExcludeSalesAmount";
    }

    public String getVariableName() {
        return "\u5168\u6708\u5168\u54c1\u6298\u540e\u4efb\u52a1\u91cf\u5254\u91cf\uff08\u4e3b\u4f53\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public Boolean isConfigurable() {
        return true;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        List<SalesGoalVo> data = this.conVariableRegisterParamHandler.findExcludeSalesGoalData(calculateDto, this.getVariableCode());
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (CollectionUtils.isEmpty(data)) {
            return resultMap;
        }
        BigDecimal total = BigDecimal.ZERO;
        for (SalesGoalVo dataVo : data) {
            if (!Objects.nonNull(dataVo.getDeliveryDiscountSalesAmount())) continue;
            total = total.add(dataVo.getDeliveryDiscountSalesAmount());
        }
        resultMap.put(this.getVariableCode(), total);
        return resultMap;
    }
}

