/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.mainstay;

import com.biz.crm.mdm.business.product.sdk.dto.ProductDto;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.dto.MainOnedaySalesDataDto;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.service.MainOnedaySaleDataService;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.vo.MainOnedaySalesDataVo;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AllProductAllMonthDiscountTaskApprovedRateOutRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(AllProductAllMonthDiscountTaskApprovedRateOutRegister.class);
    @Autowired(required=false)
    private MainOnedaySaleDataService mainOnedaySaleDataService;
    @Autowired(required=false)
    private SalesGoalService salesGoalService;
    @Autowired(required=false)
    private ProductVoService productVoService;

    public String getVariableCode() {
        return "allProductAllMonthDiscountTaskApprovedRateOut";
    }

    public String getVariableName() {
        return "\u5168\u54c1\u5168\u6708\u6298\u540e\u4efb\u52a1\u91cf\u8fbe\u6210\u7387\uff08\u5254\u91cf\uff09\uff08\u4e3b\u4f53\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        MainOnedaySalesDataDto salesDataDto = new MainOnedaySalesDataDto();
        SalesGoalDto salesGoalDto = new SalesGoalDto();
        Validate.notBlank((CharSequence)calculateDto.getYearMonthLy(), (String)"\u5e74\u6708\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        salesDataDto.setYearMonthLy(calculateDto.getYearMonthLy().replaceAll("-", ""));
        salesGoalDto.setYearMonthLy(calculateDto.getYearMonthLy());
        salesDataDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        salesGoalDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        salesDataDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        salesGoalDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        if (!CollectionUtils.isEmpty((Collection)calculateDto.getCustomerCodeList())) {
            salesDataDto.setCustomerCodeList((List)Lists.newArrayList((Iterable)calculateDto.getCustomerCodeList()));
            salesGoalDto.setCustomerCodeList((List)Lists.newArrayList((Iterable)calculateDto.getCustomerCodeList()));
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getSalesGroupCode())) {
            salesDataDto.setSalesOrgProvinceCode(calculateDto.getSalesGroupCode());
            salesGoalDto.setSalesOrgProvinceCode(calculateDto.getSalesGroupCode());
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getSalesRegionCode())) {
            salesDataDto.setSalesOrgRegionCode(calculateDto.getSalesRegionCode());
            salesGoalDto.setSalesOrgRegionCode(calculateDto.getSalesRegionCode());
        } else {
            throw new RuntimeException("\u5ba2\u6237\u7f16\u7801\u3001\u9500\u552e\u7ec4\u3001\u9500\u552e\u90e8\u95e8\u5168\u90e8\u4e3a\u7a7a");
        }
        ProductDto dto = new ProductDto();
        ArrayList<String> includeMainCategoryList = new ArrayList<String>();
        includeMainCategoryList.add("1");
        includeMainCategoryList.add("2");
        includeMainCategoryList.add("3");
        dto.setIncludeMainCategoryList(includeMainCategoryList);
        List productVos = this.productVoService.queryCondition(dto);
        if (!CollectionUtils.isEmpty((Collection)productVos)) {
            List excludeProductCodeList = productVos.stream().map(ProductVo::getProductCode).distinct().collect(Collectors.toList());
            salesDataDto.setExcludeProductCodeList(excludeProductCodeList);
            salesGoalDto.setExcludeProductCodeList(excludeProductCodeList);
        }
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(1);
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        List salesDataVos = this.mainOnedaySaleDataService.listMainOnedaySalesData(salesDataDto);
        BigDecimal minusDiscountBehindTaxSaleAmountIn = salesDataVos.stream().filter(e -> Objects.nonNull(e.getMinusDiscountBehindTaxSaleAmountIn())).map(MainOnedaySalesDataVo::getMinusDiscountBehindTaxSaleAmountIn).reduce(BigDecimal.ZERO, BigDecimal::add);
        salesGoalDto.setYearSalesTypeCode("contract");
        List salesGoalVos = this.salesGoalService.listForVariableCal(salesGoalDto);
        BigDecimal deliveryDiscountSalesAmount = salesGoalVos.stream().filter(e -> Objects.nonNull(e.getDeliveryDiscountSalesAmount())).map(SalesGoalVo::getDeliveryDiscountSalesAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (BigDecimal.ZERO.compareTo(minusDiscountBehindTaxSaleAmountIn) == 0 || BigDecimal.ZERO.compareTo(deliveryDiscountSalesAmount) == 0) {
            return resultMap;
        }
        BigDecimal rate = minusDiscountBehindTaxSaleAmountIn.divide(deliveryDiscountSalesAmount, 8, 4);
        resultMap.put(this.getVariableCode(), rate);
        return resultMap;
    }
}

