/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.mainstay;

import com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator.common.AuditExecuteIndicatorParamBuilder;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BigDayProductQuantityRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(BigDayProductQuantityRegister.class);
    @Autowired(required=false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;

    public String getVariableCode() {
        return "bigDayProductQuantity";
    }

    public String getVariableName() {
        return "\u5927\u65e5\u671f\u4ea7\u54c1\u4ef6\u6570\uff08\u4e3b\u4f53\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        Validate.notBlank((CharSequence)calculateDto.getDetailPlanItemCode(), (String)"\u7ec6\u6848\u660e\u7ec6\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        AuditExecuteIndicatorDto dto = AuditExecuteIndicatorParamBuilder.buildMainParam(calculateDto, this.getVariableCode());
        List resultList = this.auditExecuteIndicatorService.findListForVariable(dto);
        if (!CollectionUtils.isEmpty((Collection)resultList)) {
            resultMap.put(this.getVariableCode(), ((AuditExecuteIndicatorVo)resultList.get(0)).getIndicatorValue());
            return resultMap;
        }
        dto = AuditExecuteIndicatorParamBuilder.buildOtherParam(calculateDto, this.getVariableCode());
        dto.setActivityTypeCode(calculateDto.getActivityTypeCode());
        dto.setActivityFormCode(calculateDto.getActivityFormCode());
        dto.setProductCode(calculateDto.getProductCode());
        dto.setProductItemCode(calculateDto.getItemCode());
        dto.setProductCategoryCode(calculateDto.getCategoryCode());
        dto.setProductBrandCode(calculateDto.getBrandCode());
        dto.setSalesInstitutionCode(calculateDto.getSalesOrganizationCode());
        dto.setSalesRegionCode(calculateDto.getSalesRegionCode());
        dto.setSalesOrgCode(calculateDto.getSalesGroupCode());
        resultList = this.auditExecuteIndicatorService.findListForVariable(dto);
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return resultMap;
        }
        resultMap.put(this.getVariableCode(), ((AuditExecuteIndicatorVo)resultList.get(0)).getIndicatorValue());
        return resultMap;
    }
}

