/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.mainstay;

import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.dto.MainOnedaySalesDataDto;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.service.MainOnedaySaleDataService;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.vo.MainOnedaySalesDataVo;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.ConItemTypeEnum;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.biz.crm.tpm.business.variable.sdk.service.ConVariableDetailSdkService;
import com.biz.crm.tpm.business.variable.sdk.vo.ConVariableDetailVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class CategoryBeforeDiscountReplyRateRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(CategoryBeforeDiscountReplyRateRegister.class);
    @Autowired(required=false)
    private MainOnedaySaleDataService mainOnedaySaleDataService;
    @Autowired(required=false)
    private SalesPlanService salesPlanService;
    @Autowired(required=false)
    private ConVariableDetailSdkService conVariableDetailSdkService;

    public String getVariableCode() {
        return "categoryBeforeDiscountReplyRate";
    }

    public String getVariableName() {
        return "\u54c1\u7c7b\u6298\u524d\u56de\u590d\u91cf\u8fbe\u6210\u7387\uff08\u4e3b\u4f53\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public Boolean isConfigurable() {
        return true;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        List filterList;
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(1);
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        MainOnedaySalesDataDto salesDataDto = new MainOnedaySalesDataDto();
        SalesPlanDto salesPlanDto = new SalesPlanDto();
        salesDataDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        salesPlanDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        salesDataDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        salesPlanDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        if (!CollectionUtils.isEmpty((Collection)calculateDto.getCustomerCodeList())) {
            salesDataDto.setCustomerCodeList((List)Lists.newArrayList((Iterable)calculateDto.getCustomerCodeList()));
            salesPlanDto.setCustomerCodeList((List)Lists.newArrayList((Iterable)calculateDto.getCustomerCodeList()));
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getSalesGroupCode())) {
            salesDataDto.setSalesOrgProvinceCode(calculateDto.getSalesGroupCode());
            salesPlanDto.setSalesOrgProvinceCode(calculateDto.getSalesGroupCode());
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getSalesRegionCode())) {
            salesDataDto.setSalesOrgRegionCode(calculateDto.getSalesRegionCode());
            salesPlanDto.setSalesOrgRegionCode(calculateDto.getSalesRegionCode());
        } else {
            throw new RuntimeException("\u5ba2\u6237\u7f16\u7801\u3001\u9500\u552e\u7ec4\u3001\u9500\u552e\u90e8\u95e8\u5168\u90e8\u4e3a\u7a7a");
        }
        List conVariableDetailVos = this.conVariableDetailSdkService.findConVariableList(calculateDto.getAuditFormulaCode(), this.getVariableCode());
        List productCodes = conVariableDetailVos.stream().filter(e -> StringUtils.equals((CharSequence)ConItemTypeEnum.INCLUDE_GOODS.getCode(), (CharSequence)e.getItemType())).map(ConVariableDetailVo::getItemCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(productCodes)) {
            return resultMap;
        }
        salesDataDto.setProductCodes(productCodes);
        salesPlanDto.setSalesProductCodeList(productCodes);
        if (!CollectionUtils.isEmpty((Collection)conVariableDetailVos) && !CollectionUtils.isEmpty(filterList = conVariableDetailVos.stream().filter(e -> Objects.nonNull(e.getBeginTime()) && Objects.nonNull(e.getEndTime())).collect(Collectors.toList()))) {
            ConVariableDetailVo variableDetailVo = (ConVariableDetailVo)conVariableDetailVos.get(0);
            salesDataDto.setStartTimeOrDate(DateUtil.format((Date)variableDetailVo.getBeginTime(), (String)"yyyy-MM-dd"));
            salesDataDto.setEndTimeOrDate(DateUtil.format((Date)variableDetailVo.getEndTime(), (String)"yyyy-MM-dd"));
        }
        if (StringUtils.isEmpty((CharSequence)salesDataDto.getStartTimeOrDate()) && StringUtils.isEmpty((CharSequence)salesDataDto.getEndTimeOrDate())) {
            Assert.notNull((Object)calculateDto.getStartTimeOrDate(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)calculateDto.getEndTimeOrDate(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            salesDataDto.setStartTimeOrDate(DateUtil.format((Date)calculateDto.getStartTimeOrDate(), (String)"yyyy-MM-dd"));
            salesDataDto.setEndTimeOrDate(DateUtil.format((Date)calculateDto.getEndTimeOrDate(), (String)"yyyy-MM-dd"));
        }
        salesPlanDto.setYearMonthLyBegin(salesDataDto.getStartTimeOrDate().substring(0, 7));
        salesPlanDto.setYearMonthLyEnd(salesDataDto.getEndTimeOrDate().substring(0, 7));
        salesDataDto.setStartTimeOrDate(salesDataDto.getStartTimeOrDate().replaceAll("-", ""));
        salesDataDto.setEndTimeOrDate(salesDataDto.getEndTimeOrDate().replaceAll("-", ""));
        List salesDataVos = this.mainOnedaySaleDataService.listMainOnedaySalesData(salesDataDto);
        BigDecimal salesAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty((Collection)salesDataVos)) {
            BigDecimal minusDiscountFrontTaxSaleAmount = salesDataVos.stream().filter(e -> Objects.nonNull(e.getMinusDiscountFrontTaxSaleAmount())).map(MainOnedaySalesDataVo::getMinusDiscountFrontTaxSaleAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal minusMilkCardDiscountBehindOrderAmountToB = salesDataVos.stream().filter(e -> Objects.nonNull(e.getMinusMilkCardDiscountBehindOrderAmountToB())).map(MainOnedaySalesDataVo::getMinusMilkCardDiscountBehindOrderAmountToB).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal minusMilkCardDiscountBehindOrderAmountToC = salesDataVos.stream().filter(e -> Objects.nonNull(e.getMinusMilkCardDiscountBehindOrderAmountToC())).map(MainOnedaySalesDataVo::getMinusMilkCardDiscountBehindOrderAmountToC).reduce(BigDecimal.ZERO, BigDecimal::add);
            salesAmount = minusDiscountFrontTaxSaleAmount.add(minusMilkCardDiscountBehindOrderAmountToB).add(minusMilkCardDiscountBehindOrderAmountToC);
        }
        List salesPlanVos = this.salesPlanService.findByConditions(salesPlanDto);
        BigDecimal restoreAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty((Collection)salesPlanVos)) {
            restoreAmount = salesPlanVos.stream().filter(e -> Objects.nonNull(e.getRestoreAmount())).map(SalesPlanVo::getRestoreAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (BigDecimal.ZERO.compareTo(restoreAmount) == 0) {
            return resultMap;
        }
        BigDecimal rate = salesAmount.divide(restoreAmount, 8, RoundingMode.HALF_UP);
        resultMap.put(this.getVariableCode(), rate);
        return resultMap;
    }
}

