/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.mainstay;

import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CompanyFeeRateRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(CompanyFeeRateRegister.class);
    @Autowired(required=false)
    private ActivityDetailPlanItemService activityDetailPlanItemService;

    public String getVariableCode() {
        return "companyFeeRate";
    }

    public String getVariableName() {
        return "\u516c\u53f8\u627f\u62c5\u6bd4\u4f8b\uff08\u4e3b\u4f53\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        return list;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank((CharSequence)calculateDto.getDetailPlanItemCode(), (String)"\u7ec6\u6848\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List resultList = this.activityDetailPlanItemService.findByItemCodes((List)Lists.newArrayList((Object[])new String[]{calculateDto.getDetailPlanItemCode()}));
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return resultMap;
        }
        ActivityDetailPlanItemVo itemVo = (ActivityDetailPlanItemVo)resultList.get(0);
        BigDecimal feeAmount = Objects.nonNull(itemVo.getFeeAmount()) ? itemVo.getFeeAmount() : BigDecimal.ZERO;
        BigDecimal totalFeeAmount = Objects.nonNull(itemVo.getTotalFeeAmount()) ? itemVo.getTotalFeeAmount() : BigDecimal.ZERO;
        BigDecimal rate = BigDecimal.ZERO;
        if (BigDecimal.ZERO.compareTo(totalFeeAmount) != 0) {
            rate = feeAmount.divide(totalFeeAmount, 8, RoundingMode.HALF_UP);
        }
        resultMap.put(this.getVariableCode(), rate);
        return resultMap;
    }
}

