/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.mainstay;

import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class CustomerLevelRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(CustomerLevelRegister.class);
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;

    public String getVariableCode() {
        return "customerLevel";
    }

    public String getVariableName() {
        return "\u5ba2\u6237\u7b49\u7ea7\uff08\u4e3b\u4f53\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        Validate.notBlank((CharSequence)calculateDto.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List customerVos = this.customerVoService.findBaseByCustomerCodes((List)Lists.newArrayList((Object[])new String[]{calculateDto.getCustomerCode()}));
        Validate.notEmpty((Collection)customerVos, (String)"\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        String customerLevel = ((CustomerVo)customerVos.get(0)).getCustomerLevel();
        if (StringUtils.isEmpty((Object)customerLevel)) {
            log.error("\u5ba2\u6237\u4fe1\u606f-\u5ba2\u6237\u7b49\u7ea7\u4e3a\u7a7a\uff01");
            return resultMap;
        }
        DictDataVo dictDataVo = this.dictDataVoService.findByDictTypeCodeAndDictCode("mdm_customer_level", customerLevel);
        Validate.notNull((Object)dictDataVo, (String)"\u5ba2\u6237\u7b49\u7ea7[%s]\u5728\u6570\u636e\u5b57\u5178[%s]\u4e0d\u5b58\u5728\uff01", (Object[])new Object[]{customerLevel, "mdm_customer_level"});
        Validate.notBlank((CharSequence)dictDataVo.getDictDesc(), (String)"\u5ba2\u6237\u7b49\u7ea7[%s]\u5728\u6570\u636e\u5b57\u5178[%s]\u672a\u914d\u7f6e\u5bf9\u5e94\u63cf\u8ff0\uff01", (Object[])new Object[]{customerLevel, "mdm_customer_level"});
        try {
            BigDecimal value = new BigDecimal(dictDataVo.getDictDesc());
            resultMap.put(this.getVariableCode(), value);
        }
        catch (Exception e) {
            log.error("\u5ba2\u6237\u7b49\u7ea7\uff08\u4e3b\u4f53\uff09[" + customerLevel + "]\u8f6c\u6362\u7b49\u7ea7\u5bf9\u5e94\u503c\u5f02\u5e38!" + e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u5ba2\u6237\u7b49\u7ea7[" + customerLevel + "]\u5728\u6570\u636e\u5b57\u5178[" + "mdm_customer_level" + "]\u63cf\u8ff0\u683c\u5f0f\u9519\u8bef\uff0c\u53ea\u80fd\u662f\u7eaf\u6570\u5b57\uff01");
        }
        return resultMap;
    }
}

