/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.mainstay;

import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.vo.MainOnedaySalesDataVo;
import com.biz.crm.tpm.business.variable.local.register.configure.common.ConVariableRegisterParamHandler;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FirstTenDaysMarkProductQuantityRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(FirstTenDaysMarkProductQuantityRegister.class);
    @Autowired(required=false)
    private ConVariableRegisterParamHandler conVariableRegisterParamHandler;

    public String getVariableCode() {
        return "firstTenDaysMarkProductQuantity";
    }

    public String getVariableName() {
        return "\u4e0a\u65ec\u6307\u5b9a\u4ea7\u54c1\u4ef6\u6570\uff08\u4e3b\u4f53\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public Boolean isConfigurable() {
        return true;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        List<MainOnedaySalesDataVo> data = this.conVariableRegisterParamHandler.findIncludeData(calculateDto, this.getVariableCode());
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (CollectionUtils.isEmpty(data)) {
            return resultMap;
        }
        BigDecimal total = BigDecimal.ZERO;
        for (MainOnedaySalesDataVo dataVo : data) {
            if (!Objects.nonNull(dataVo.getMinusSaleQuantity())) continue;
            total = total.add(dataVo.getMinusSaleQuantity());
        }
        resultMap.put(this.getVariableCode(), total);
        return resultMap;
    }
}

