/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.mainstay;

import com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator.common.AuditExecuteIndicatorParamBuilder;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MainStayPosSalesQuantityRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(MainStayPosSalesQuantityRegister.class);
    @Autowired(required=false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;

    public String getVariableCode() {
        return "mainStayPosSalesQuantity";
    }

    public String getVariableName() {
        return "POS\u9500\u552e\u6570\uff08\u4e3b\u4f53\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        return list;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank((CharSequence)calculateDto.getYearMonthLy(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getActivityTypeCode(), (String)"\u6d3b\u52a8\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getActivityFormCode(), (String)"\u6d3b\u52a8\u5f62\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        AuditExecuteIndicatorDto dto = AuditExecuteIndicatorParamBuilder.buildMainParam(calculateDto, this.getVariableCode());
        List resultList = this.auditExecuteIndicatorService.findListForVariable(dto);
        if (!CollectionUtils.isEmpty((Collection)resultList)) {
            resultMap.put(this.getVariableCode(), ((AuditExecuteIndicatorVo)resultList.get(0)).getIndicatorValue());
            return resultMap;
        }
        dto = AuditExecuteIndicatorParamBuilder.buildOtherParam(calculateDto, this.getVariableCode());
        dto.setActivityTypeCode(calculateDto.getActivityTypeCode());
        dto.setActivityFormCode(calculateDto.getActivityFormCode());
        dto.setProductCode(calculateDto.getProductCode());
        dto.setProductItemCode(calculateDto.getItemCode());
        dto.setProductCategoryCode(calculateDto.getCategoryCode());
        dto.setProductBrandCode(calculateDto.getBrandCode());
        dto.setSalesInstitutionCode(calculateDto.getSalesOrganizationCode());
        dto.setSalesRegionCode(calculateDto.getSalesRegionCode());
        dto.setSalesOrgCode(calculateDto.getSalesGroupCode());
        resultList = this.auditExecuteIndicatorService.findListForVariable(dto);
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return resultMap;
        }
        resultMap.put(this.getVariableCode(), ((AuditExecuteIndicatorVo)resultList.get(0)).getIndicatorValue());
        return resultMap;
    }
}

