/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.mainstay;

import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.dto.MainOnedaySalesDataDto;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.service.MainOnedaySaleDataService;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.vo.MainOnedaySalesDataVo;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.ConItemTypeEnum;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.biz.crm.tpm.business.variable.sdk.service.ConVariableDetailSdkService;
import com.biz.crm.tpm.business.variable.sdk.vo.ConVariableDetailVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class MarkProductDuringActTaskApprovedRateMilkRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(MarkProductDuringActTaskApprovedRateMilkRegister.class);
    @Autowired(required=false)
    private MainOnedaySaleDataService mainOnedaySaleDataService;
    @Autowired(required=false)
    private SalesGoalService salesGoalService;
    @Autowired(required=false)
    private ConVariableDetailSdkService conVariableDetailSdkService;

    public String getVariableCode() {
        return "markProductDuringActTaskApprovedRateMilk";
    }

    public String getVariableName() {
        return "\u6307\u5b9a\u4ea7\u54c1\u6d3b\u52a8\u671f\u95f4\u4efb\u52a1\u8fbe\u6210\u7387\uff08\u542b\u5976\u5361\uff09\uff08\u4e3b\u4f53\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public Boolean isConfigurable() {
        return true;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        List filterList;
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(1);
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        MainOnedaySalesDataDto salesDataDto = new MainOnedaySalesDataDto();
        SalesGoalDto salesGoalDto = new SalesGoalDto();
        salesDataDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        salesGoalDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        salesDataDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        salesGoalDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        if (!CollectionUtils.isEmpty((Collection)calculateDto.getCustomerCodeList())) {
            salesDataDto.setCustomerCodeList((List)Lists.newArrayList((Iterable)calculateDto.getCustomerCodeList()));
            salesGoalDto.setCustomerCodeList((List)Lists.newArrayList((Iterable)calculateDto.getCustomerCodeList()));
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getSalesGroupCode())) {
            salesDataDto.setSalesOrgProvinceCode(calculateDto.getSalesGroupCode());
            salesGoalDto.setSalesOrgProvinceCode(calculateDto.getSalesGroupCode());
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getSalesRegionCode())) {
            salesDataDto.setSalesOrgRegionCode(calculateDto.getSalesRegionCode());
            salesGoalDto.setSalesOrgRegionCode(calculateDto.getSalesRegionCode());
        } else {
            throw new RuntimeException("\u5ba2\u6237\u7f16\u7801\u3001\u9500\u552e\u7ec4\u3001\u9500\u552e\u90e8\u95e8\u5168\u90e8\u4e3a\u7a7a");
        }
        List conVariableDetailVos = this.conVariableDetailSdkService.findConVariableList(calculateDto.getAuditFormulaCode(), this.getVariableCode());
        List productCodes = conVariableDetailVos.stream().filter(e -> StringUtils.equals((CharSequence)ConItemTypeEnum.INCLUDE_GOODS.getCode(), (CharSequence)e.getItemType())).map(ConVariableDetailVo::getItemCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(productCodes)) {
            return resultMap;
        }
        salesDataDto.setProductCodes(productCodes);
        salesGoalDto.setIncludeProductCodeList(productCodes);
        if (!CollectionUtils.isEmpty((Collection)conVariableDetailVos) && !CollectionUtils.isEmpty(filterList = conVariableDetailVos.stream().filter(e -> Objects.nonNull(e.getBeginTime()) && Objects.nonNull(e.getEndTime())).collect(Collectors.toList()))) {
            ConVariableDetailVo variableDetailVo = (ConVariableDetailVo)conVariableDetailVos.get(0);
            salesDataDto.setStartTimeOrDate(DateUtil.format((Date)variableDetailVo.getBeginTime(), (String)"yyyy-MM-dd"));
            salesDataDto.setEndTimeOrDate(DateUtil.format((Date)variableDetailVo.getEndTime(), (String)"yyyy-MM-dd"));
        }
        if (StringUtils.isEmpty((CharSequence)salesDataDto.getStartTimeOrDate()) && StringUtils.isEmpty((CharSequence)salesDataDto.getEndTimeOrDate())) {
            Assert.notNull((Object)calculateDto.getStartTimeOrDate(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)calculateDto.getEndTimeOrDate(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            salesDataDto.setStartTimeOrDate(DateUtil.format((Date)calculateDto.getStartTimeOrDate(), (String)"yyyy-MM-dd"));
            salesDataDto.setEndTimeOrDate(DateUtil.format((Date)calculateDto.getEndTimeOrDate(), (String)"yyyy-MM-dd"));
        }
        HashSet<String> yearMonthLySet = new HashSet<String>();
        yearMonthLySet.add(salesDataDto.getStartTimeOrDate().substring(0, 7));
        yearMonthLySet.add(salesDataDto.getEndTimeOrDate().substring(0, 7));
        salesGoalDto.setYearMonthLySet(yearMonthLySet);
        salesDataDto.setStartTimeOrDate(salesDataDto.getStartTimeOrDate().replaceAll("-", ""));
        salesDataDto.setEndTimeOrDate(salesDataDto.getEndTimeOrDate().replaceAll("-", ""));
        List salesDataVos = this.mainOnedaySaleDataService.listMainOnedaySalesData(salesDataDto);
        BigDecimal minusDiscountBehindTaxSaleAmountIn = salesDataVos.stream().filter(e -> Objects.nonNull(e.getMinusDiscountBehindTaxSaleAmountIn())).map(MainOnedaySalesDataVo::getMinusDiscountBehindTaxSaleAmountIn).reduce(BigDecimal.ZERO, BigDecimal::add);
        salesGoalDto.setYearSalesTypeCode("contract");
        List salesGoalVos = this.salesGoalService.listForVariableCal(salesGoalDto);
        BigDecimal deliveryDiscountSalesAmount = salesGoalVos.stream().filter(e -> Objects.nonNull(e.getDeliveryDiscountSalesAmount())).map(SalesGoalVo::getDeliveryDiscountSalesAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (BigDecimal.ZERO.compareTo(minusDiscountBehindTaxSaleAmountIn) == 0 || BigDecimal.ZERO.compareTo(deliveryDiscountSalesAmount) == 0) {
            return resultMap;
        }
        BigDecimal rate = minusDiscountBehindTaxSaleAmountIn.divide(deliveryDiscountSalesAmount, 8, RoundingMode.HALF_UP);
        resultMap.put(this.getVariableCode(), rate);
        return resultMap;
    }
}

