/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.mainstay;

import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.ConItemTypeEnum;
import com.biz.crm.tpm.business.variable.sdk.enums.CustomVariableSummaryDimensionEnum;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.biz.crm.tpm.business.variable.sdk.service.ConVariableDetailSdkService;
import com.biz.crm.tpm.business.variable.sdk.vo.ConVariableDetailVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MaxActivityProductAllMonthSysReplayOrApplyNumberRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(MaxActivityProductAllMonthSysReplayOrApplyNumberRegister.class);
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private SalesPlanService salesPlanService;
    @Autowired(required=false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;
    @Autowired(required=false)
    private ConVariableDetailSdkService conVariableDetailSdkService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;

    public String getVariableCode() {
        return "maxActivityProductAllMonthSysReplayOrApplyNumber";
    }

    public String getVariableName() {
        return "max\uff08\u6d3b\u52a8\u4ea7\u54c1\u5168\u6708\u7cfb\u7edf\u56de\u590d\u91cf\u4ef6\u6570\uff0c\u6d3b\u52a8\u4ea7\u54c1\u5168\u6708\u7533\u8bf7\u4ef6\u6570\uff09\uff08\u4e3b\u4f53\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public Boolean isConfigurable() {
        return true;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank((CharSequence)calculateDto.getDetailPlanItemCode(), (String)"\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getYearMonthLy(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getStartTimeOrDate(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getEndTimeOrDate(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((Collection)calculateDto.getCustomerCodeList(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(1);
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        BigDecimal periodChPromoteQuantity = BigDecimal.ZERO;
        AuditExecuteIndicatorDto indicatorDto = new AuditExecuteIndicatorDto();
        indicatorDto.setActiveNumber(calculateDto.getDetailPlanItemCode());
        List indicatorVoList = this.auditExecuteIndicatorService.findListForVariable(indicatorDto);
        if (!CollectionUtils.isEmpty((Collection)indicatorVoList)) {
            periodChPromoteQuantity = ((AuditExecuteIndicatorVo)indicatorVoList.get(0)).getIndicatorValue();
        } else {
            List<ConVariableDetailVo> variableDetailVos = this.conVariableDetailSdkService.findConVariableList(calculateDto.getAuditFormulaCode(), this.getVariableCode());
            variableDetailVos = variableDetailVos.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getSummaryDimension())).collect(Collectors.toList());
            Validate.notEmpty(variableDetailVos, (String)"max\uff08\u6d3b\u52a8\u4ea7\u54c1\u5168\u6708\u7cfb\u7edf\u56de\u590d\u91cf\u4ef6\u6570\uff0c\u6d3b\u52a8\u4ea7\u54c1\u5168\u6708\u7533\u8bf7\u4ef6\u6570\uff09 \u672a\u914d\u7f6e\u6c47\u603b\u7ef4\u5ea6\uff01", (Object[])new Object[0]);
            periodChPromoteQuantity = this.getPeriodChPromoteQuantity(variableDetailVos, calculateDto);
        }
        log.info("\u6d3b\u52a8\u4ea7\u54c1\u5168\u6708\u7533\u8bf7\u4ef6\u6570:{}", (Object)periodChPromoteQuantity);
        SalesPlanDto dto = new SalesPlanDto();
        dto.setCustomerCodeList((List)Lists.newArrayList((Iterable)calculateDto.getCustomerCodeList()));
        dto.setYearMonthLyBegin(DateUtil.format((Date)calculateDto.getStartTimeOrDate(), (String)"yyyy-MM"));
        dto.setYearMonthLyEnd(DateUtil.format((Date)calculateDto.getEndTimeOrDate(), (String)"yyyy-MM"));
        if (StringUtils.isNotEmpty((CharSequence)calculateDto.getProductCode())) {
            dto.setSalesProductCodeList(Arrays.asList(calculateDto.getProductCode().split(",")));
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getItemCode())) {
            dto.setProductItemCode(calculateDto.getItemCode());
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getCategoryCode())) {
            dto.setProductCategoryCode(calculateDto.getCategoryCode());
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getBrandCode()) && !StringUtils.equals((CharSequence)"130000", (CharSequence)calculateDto.getBrandCode())) {
            dto.setProductBrandCode(calculateDto.getBrandCode());
        }
        List salesPlanVos = this.salesPlanService.findByConditions(dto);
        BigDecimal monthReturnQuantity = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty((Collection)salesPlanVos)) {
            monthReturnQuantity = salesPlanVos.stream().filter(e -> Objects.nonNull(e.getRestoreQuantity())).map(SalesPlanVo::getRestoreQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        log.info("\u6d3b\u52a8\u4ea7\u54c1\u5168\u6708\u7cfb\u7edf\u56de\u590d\u91cf\u4ef6\u6570:{}", (Object)monthReturnQuantity);
        if (Objects.isNull(periodChPromoteQuantity)) {
            periodChPromoteQuantity = BigDecimal.ZERO;
        }
        resultMap.put(this.getVariableCode(), periodChPromoteQuantity.compareTo(monthReturnQuantity) > 0 ? periodChPromoteQuantity : monthReturnQuantity);
        return resultMap;
    }

    private BigDecimal getPeriodChPromoteQuantity(List<ConVariableDetailVo> variableDetailVos, CalculateDto calculateDto) {
        String summaryDimension = variableDetailVos.get(0).getSummaryDimension();
        ActivityDetailPlanItemDto dto = new ActivityDetailPlanItemDto();
        if (StringUtils.equals((CharSequence)CustomVariableSummaryDimensionEnum.FIRST_CHANNEL_PRODUCT.getCode(), (CharSequence)summaryDimension)) {
            Validate.notBlank((CharSequence)calculateDto.getFirstChannelCode(), (String)"\u4e00\u7ea7\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            dto.setFirstChannelCode(calculateDto.getFirstChannelCode());
        } else if (StringUtils.equals((CharSequence)CustomVariableSummaryDimensionEnum.SECOND_CHANNEL_PRODUCT.getCode(), (CharSequence)summaryDimension)) {
            Validate.notBlank((CharSequence)calculateDto.getSecondChannelCode(), (String)"\u4e8c\u7ea7\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            dto.setSecondChannelCode(calculateDto.getSecondChannelCode());
        } else if (StringUtils.equals((CharSequence)CustomVariableSummaryDimensionEnum.CUSTOMER_PRODUCT.getCode(), (CharSequence)summaryDimension)) {
            Validate.notEmpty((Collection)calculateDto.getCustomerCodeList(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            dto.setCustomerCodes((List)Lists.newArrayList((Iterable)calculateDto.getCustomerCodeList()));
        } else {
            throw new RuntimeException("max\uff08\u6d3b\u52a8\u4ea7\u54c1\u5168\u6708\u7cfb\u7edf\u56de\u590d\u91cf\u4ef6\u6570\uff0c\u6d3b\u52a8\u4ea7\u54c1\u5168\u6708\u7533\u8bf7\u4ef6\u6570\uff09 \u672a\u77e5\u6c47\u603b\u7ef4\u5ea6[" + summaryDimension + "]\uff01");
        }
        Validate.notBlank((CharSequence)calculateDto.getProductCode(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List activityFormCodeList = variableDetailVos.stream().filter(e -> StringUtils.equals((CharSequence)ConItemTypeEnum.INCLUDE_ACTIVITY_FORM.getCode(), (CharSequence)e.getItemType()) && StringUtils.isNotEmpty((CharSequence)e.getItemCode())).map(ConVariableDetailVo::getItemCode).distinct().collect(Collectors.toList());
        List salesOrgCodeList = variableDetailVos.stream().filter(e -> StringUtils.equals((CharSequence)ConItemTypeEnum.INCLUDE_SALES_ORG.getCode(), (CharSequence)e.getItemType()) && StringUtils.isNotEmpty((CharSequence)e.getItemCode())).map(ConVariableDetailVo::getItemCode).distinct().collect(Collectors.toList());
        Validate.notEmpty(activityFormCodeList, (String)"max\uff08\u6d3b\u52a8\u4ea7\u54c1\u5168\u6708\u7cfb\u7edf\u56de\u590d\u91cf\u4ef6\u6570\uff0c\u6d3b\u52a8\u4ea7\u54c1\u5168\u6708\u7533\u8bf7\u4ef6\u6570\uff09\u53ef\u9009\u6d3b\u52a8\u5f62\u5f0f\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty(salesOrgCodeList, (String)"max\uff08\u6d3b\u52a8\u4ea7\u54c1\u5168\u6708\u7cfb\u7edf\u56de\u590d\u91cf\u4ef6\u6570\uff0c\u6d3b\u52a8\u4ea7\u54c1\u5168\u6708\u7533\u8bf7\u4ef6\u6570\uff09\u53ef\u9009\u9500\u552e\u7ec4\u7ec7\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List allSalesOrgVos = this.salesOrgVoService.findAllChildrenBySalesOrgCodes(salesOrgCodeList);
        Validate.notEmpty((Collection)allSalesOrgVos, (String)"max\uff08\u6d3b\u52a8\u4ea7\u54c1\u5168\u6708\u7cfb\u7edf\u56de\u590d\u91cf\u4ef6\u6570\uff0c\u6d3b\u52a8\u4ea7\u54c1\u5168\u6708\u7533\u8bf7\u4ef6\u6570\uff09\u53ef\u9009\u9500\u552e\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        salesOrgCodeList = allSalesOrgVos.stream().map(SalesOrgVo::getSalesOrgCode).distinct().collect(Collectors.toList());
        dto.setIncludeProductCodeList(Arrays.asList(calculateDto.getProductCode().split(",")));
        dto.setIncludeActivityFormCodeList(activityFormCodeList);
        dto.setIncludeActivityOrgCodeList(salesOrgCodeList);
        dto.setFeeYearMonthStrBegin(DateUtil.format((Date)calculateDto.getStartTimeOrDate(), (String)"yyyy-MM") + "-01 00:00:00");
        dto.setFeeYearMonthStrEnd(DateUtil.format((Date)calculateDto.getEndTimeOrDate(), (String)"yyyy-MM") + "-01 00:00:00");
        List vos = this.activityDetailPlanItemSdkService.listForVariable(dto);
        if (CollectionUtils.isEmpty((Collection)vos)) {
            return BigDecimal.ZERO;
        }
        return vos.stream().filter(e -> Objects.nonNull(e.getPeriodChPromoteQuantity())).map(ActivityDetailPlanItemVo::getPeriodChPromoteQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
    }
}

