/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.mainstay;

import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.third.system.sdk.dto.TpmProfitabilityAnalysisDto;
import com.biz.crm.tpm.business.third.system.sdk.service.TpmProfitabilityAnalysisService;
import com.biz.crm.tpm.business.third.system.sdk.vo.TpmProfitabilityAnalysisVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PromotionApplyStoreDeliveryQuantityRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(PromotionApplyStoreDeliveryQuantityRegister.class);
    @Autowired(required=false)
    private SalesOrgSubComOrgService salesOrgSubComOrgService;
    @Autowired(required=false)
    private TpmProfitabilityAnalysisService tpmProfitabilityAnalysisService;

    public String getVariableCode() {
        return "promotionApplyStoreDeliveryQuantity";
    }

    public String getVariableName() {
        return "\u4fc3\u9500\u7533\u8bf7\u95e8\u5e97\u51fa\u5e93\u4ef6\u6570\uff08\u4e3b\u4f53\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        return list;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notNull((Object)calculateDto.getStartTimeOrDate(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getEndTimeOrDate(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getCustomerErpCode(), (String)"\u5ba2\u6237MDG\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getFirstChannelCode(), (String)"\u4e00\u7ea7\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if ("Q".equals(calculateDto.getFirstChannelCode())) {
            calculateDto.setFirstChannelCode(null);
        }
        List subComOrgVos = this.salesOrgSubComOrgService.listBySubComOrgCodeList((List)Lists.newArrayList((Object[])new String[]{calculateDto.getCustomerErpCode()}));
        Validate.notEmpty((Collection)subComOrgVos, (String)"\u672a\u83b7\u53d6\u5230\u5206\u5b50\u516c\u53f8\u4e0e\u9500\u552e\u673a\u6784\u5bf9\u5e94\u5173\u7cfb", (Object[])new Object[0]);
        String salesOrgCode = ((SalesOrgSubComOrgVo)subComOrgVos.get(0)).getSalesOrgCode();
        TpmProfitabilityAnalysisDto dto = new TpmProfitabilityAnalysisDto();
        dto.setAccountDateBegin(DateUtil.format((Date)calculateDto.getStartTimeOrDate(), (String)"yyyy-MM-dd").replaceAll("-", ""));
        dto.setAccountDateEnd(DateUtil.format((Date)calculateDto.getEndTimeOrDate(), (String)"yyyy-MM-dd").replaceAll("-", ""));
        dto.setCompanyCode(salesOrgCode);
        dto.setSpartCode("11");
        if (StringUtils.isNotEmpty((CharSequence)calculateDto.getProductCode())) {
            dto.setMaterialCodes(Arrays.asList(calculateDto.getProductCode().split(",")));
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getItemCode())) {
            dto.setItemCode(calculateDto.getItemCode());
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getCategoryCode())) {
            dto.setCategoryCode(calculateDto.getCategoryCode());
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getBrandCode()) && !StringUtils.equals((CharSequence)"130000", (CharSequence)calculateDto.getBrandCode())) {
            dto.setBrandCode(calculateDto.getBrandCode());
        }
        dto.setChannelCode(calculateDto.getFirstChannelCode());
        dto.setServiceCode(calculateDto.getStoresCode());
        List vos = this.tpmProfitabilityAnalysisService.listForVariable(dto);
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (CollectionUtils.isEmpty((Collection)vos)) {
            return resultMap;
        }
        BigDecimal total = vos.stream().filter(e -> Objects.nonNull(e.getSalesNum())).map(TpmProfitabilityAnalysisVo::getSalesNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        resultMap.put(this.getVariableCode(), total);
        return resultMap;
    }
}

