/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.mainstay;

import com.biz.crm.business.common.sdk.vo.UuidOpVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TrialSalesPeriodSummaryMonthRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(TrialSalesPeriodSummaryMonthRegister.class);
    @Autowired(required=false)
    private CustomerVoService customerVoService;

    public String getVariableCode() {
        return "trialSalesPeriodSummaryMonth";
    }

    public String getVariableName() {
        return "\u8bd5\u9500\u671f\u5408\u5e76\u8ba1\u7b97\uff08\u6708\uff09\uff08\u4e3b\u4f53\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank((CharSequence)calculateDto.getCustomerErpCode(), (String)"\u5ba2\u6237MDG\u7f16\u7801\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getEndTimeOrDate(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List customerVos = this.customerVoService.findByErpCodeList((List)Lists.newArrayList((Object[])new String[]{calculateDto.getCustomerErpCode()}));
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(1);
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (CollectionUtils.isEmpty((Collection)customerVos)) {
            return resultMap;
        }
        if (CollectionUtils.isEmpty(customerVos = customerVos.stream().filter(e -> Objects.nonNull(e.getCreateTime())).sorted(Comparator.comparing(UuidOpVo::getCreateTime)).collect(Collectors.toList()))) {
            return resultMap;
        }
        Date createTime = ((CustomerVo)customerVos.get(0)).getCreateTime();
        int result = 0;
        try {
            Calendar c1 = Calendar.getInstance();
            Calendar c2 = Calendar.getInstance();
            c1.setTime(DateUtil.date_yyyy_MM_dd.parse(DateUtil.format((Date)createTime, (String)"yyyy-MM-dd")));
            c2.setTime(DateUtil.date_yyyy_MM_dd.parse(DateUtil.format((Date)calculateDto.getEndTimeOrDate(), (String)"yyyy-MM-dd")));
            result = (c1.get(1) - c2.get(1)) * 12 + c1.get(2) - c2.get(2);
        }
        catch (Exception var7) {
            log.error("\u8bd5\u9500\u671f\uff08\u6708\uff09\uff0c\u65e5\u671f\u5904\u7406\u5f02\u5e38", (Throwable)var7);
            throw new RuntimeException("\u8bd5\u9500\u671f\uff08\u6708\uff09\uff0c\u65e5\u671f\u5904\u7406\u5f02\u5e38\uff1a" + var7.getMessage());
        }
        resultMap.put(this.getVariableCode(), new BigDecimal(result == 0 ? 1 : Math.abs(result)));
        return resultMap;
    }
}

