/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.molecule;

import com.biz.crm.tpm.business.inventory.check.manage.sdk.dto.TpmInventoryCheckDto;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.service.TpmInventoryCheckService;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.vo.TpmInventoryCheckVo;
import com.biz.crm.tpm.business.variable.local.utils.DateUtils;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public abstract class MoleculeIndexInventoryService {
    @Autowired(required=false)
    private TpmInventoryCheckService inventoryCheckService;

    public List<TpmInventoryCheckVo> findInventoryCheck(CalculateDto calculate, String inventoryType) {
        TpmInventoryCheckDto inventoryCheck = new TpmInventoryCheckDto();
        inventoryCheck.setProductCode(calculate.getProductCode());
        inventoryCheck.setBusinessFormatCode(calculate.getBusinessFormatCode());
        inventoryCheck.setBusinessUnitCode(calculate.getBusinessUnitCode());
        inventoryCheck.setInventoryType(inventoryType);
        inventoryCheck.setSalesOrgCode(calculate.getSalesOrgCode());
        inventoryCheck.setTerminalCode(calculate.getStoresCode());
        List list = this.inventoryCheckService.findListByConditions(inventoryCheck);
        if (CollectionUtils.isEmpty((Collection)list) || list.size() <= 0) {
            return null;
        }
        List<TpmInventoryCheckVo> sortedDatedList = list.stream().sorted(Comparator.comparing(TpmInventoryCheckVo::getDateOfReporting, Comparator.reverseOrder())).collect(Collectors.toList());
        return sortedDatedList;
    }

    public BigDecimal getMonthDay(CalculateDto calculate, String inventoryType, boolean monthFlag) {
        TpmInventoryCheckVo inventoryCheckVo = calculate.getInventoryCheckVo();
        if (Objects.isNull(inventoryCheckVo)) {
            return BigDecimal.ZERO;
        }
        if (!StringUtils.isEmpty((Object)inventoryType) && !inventoryType.equals(inventoryCheckVo.getInventoryType())) {
            return BigDecimal.ZERO;
        }
        if (Objects.isNull(inventoryCheckVo.getProductionStartDate())) {
            return BigDecimal.ZERO;
        }
        String productionStartDate = inventoryCheckVo.getProductionStartDate();
        LocalDate productionLocalDate = DateUtils.str2LocalDate(productionStartDate, "yyyy-MM-dd");
        LocalDate localDate = DateUtils.date2LocalDate(calculate.getDate());
        long resultNumber = monthFlag ? ChronoUnit.MONTHS.between(productionLocalDate, localDate) : ChronoUnit.DAYS.between(productionLocalDate, localDate);
        return new BigDecimal(resultNumber);
    }

    public BigDecimal getQuantity(TpmInventoryCheckVo inventoryCheckVo, String inventoryType) {
        if (Objects.isNull(inventoryCheckVo)) {
            return BigDecimal.ZERO;
        }
        if (!StringUtils.isEmpty((Object)inventoryType) && !inventoryType.equals(inventoryCheckVo.getInventoryType())) {
            return BigDecimal.ZERO;
        }
        if (Objects.isNull(inventoryCheckVo.getQuantity())) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(inventoryCheckVo.getQuantity());
    }

    public BigDecimal getExpireDate(TpmInventoryCheckVo inventoryCheckVo, String inventoryType) {
        if (Objects.isNull(inventoryCheckVo)) {
            return BigDecimal.ZERO;
        }
        if (!StringUtils.isEmpty((Object)inventoryType) && !inventoryType.equals(inventoryCheckVo.getInventoryType())) {
            return BigDecimal.ZERO;
        }
        if (Objects.isNull(inventoryCheckVo.getExpirationDate())) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(inventoryCheckVo.getExpirationDate());
    }

    public BigDecimal getExpireDays(TpmInventoryCheckVo inventoryCheckVo, String inventoryType) {
        if (Objects.isNull(inventoryCheckVo)) {
            return BigDecimal.ZERO;
        }
        if (!StringUtils.isEmpty((Object)inventoryType) && !inventoryType.equals(inventoryCheckVo.getInventoryType())) {
            return BigDecimal.ZERO;
        }
        if (Objects.isNull(inventoryCheckVo.getExpirationDays())) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(inventoryCheckVo.getExpirationDays());
    }
}

