/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.molecule;

import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmSapDaySalesDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.service.TpmSapDaySalesService;
import com.biz.crm.tpm.business.daily.sales.data.sdk.vo.TpmSapDaySalesVo;
import com.biz.crm.tpm.business.variable.local.register.subcompany.common.SapDeliveryRegisterParamBuilder;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MoleculeSapAfterWholeProductOneToTenRegister
implements FormulaVariableRegister {
    @Autowired(required=false)
    private TpmSapDaySalesService tpmSapDaySalesService;

    public String getVariableCode() {
        return "sapAfterWholeProductOneToTen";
    }

    public String getVariableName() {
        return "SAP\u51fa\u5e93\u989d-\u6298\u540e_\u5168\u54c1_1\u81f310\u65e5\uff08\u5206\u5b50\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        return list;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank((CharSequence)calculateDto.getYearMonthLy(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        TpmSapDaySalesDto daySalesDto = SapDeliveryRegisterParamBuilder.buildParam(calculateDto);
        daySalesDto.setActivityBeginTime(calculateDto.getYearMonthLy().replaceAll("-", "") + "01");
        daySalesDto.setActivityEndTime(calculateDto.getYearMonthLy().replaceAll("-", "") + "10");
        daySalesDto.setProductCodes(null);
        daySalesDto.setBrandList(null);
        daySalesDto.setCategoryCodeList(null);
        daySalesDto.setItemCodes(null);
        List daySalesVos = this.tpmSapDaySalesService.listForVariable(daySalesDto);
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(1);
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (CollectionUtils.isEmpty((Collection)daySalesVos)) {
            return resultMap;
        }
        BigDecimal total = daySalesVos.stream().filter(e -> Objects.nonNull(e.getInvoiceAmt())).map(TpmSapDaySalesVo::getInvoiceAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        resultMap.put(this.getVariableCode(), total);
        return resultMap;
    }
}

