/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.molecule;

import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmSapDaySalesDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.service.TpmSapDaySalesService;
import com.biz.crm.tpm.business.daily.sales.data.sdk.vo.TpmSapDaySalesVo;
import com.biz.crm.tpm.business.variable.local.register.subcompany.common.SapDeliveryRegisterParamBuilder;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MoleculeSapOutNumberRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(MoleculeSapOutNumberRegister.class);
    @Autowired(required=false)
    private TpmSapDaySalesService tpmSapDaySalesService;

    public String getVariableCode() {
        return "moleculeSapOutNumber";
    }

    public String getVariableName() {
        return "SAP\u51fa\u5e93\u6570\u91cf\uff08\u5206\u5b50\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        return list;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notNull((Object)calculateDto.getStartTimeOrDate(), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getEndTimeOrDate(), (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        TpmSapDaySalesDto dto = SapDeliveryRegisterParamBuilder.buildParam(calculateDto);
        dto.setActivityBeginTime(DateUtil.format((Date)calculateDto.getStartTimeOrDate(), (String)"yyyyMMdd"));
        dto.setActivityEndTime(DateUtil.format((Date)calculateDto.getEndTimeOrDate(), (String)"yyyyMMdd"));
        List sapDaySalesVos = this.tpmSapDaySalesService.listForVariable(dto);
        BigDecimal deliveryOrderNum = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)sapDaySalesVos)) {
            for (TpmSapDaySalesVo vo : sapDaySalesVos) {
                deliveryOrderNum = deliveryOrderNum.add(new BigDecimal(vo.getDeliveryOrderNum()));
            }
        }
        HashMap resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), deliveryOrderNum);
        return resultMap;
    }
}

