/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.molecule;

import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.PriceTypeEnum;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.biz.crm.tpm.business.variable.local.register.common.PriceRegisterParamBuilder;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StandardSupplyPriceRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(StandardSupplyPriceRegister.class);
    @Autowired(required=false)
    private PriceModelVoService priceModelVoService;

    public String getVariableCode() {
        return "standardSupplyPrice";
    }

    public String getVariableName() {
        return "\u6807\u51c6\u4f9b\u8d27\u4ef7\uff08\u5206\u5b50\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);
        return list;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank((CharSequence)calculateDto.getStoresCode(), (String)"\u95e8\u5e97\u7f16\u7801\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        SearchPriceDto searchPrice = PriceRegisterParamBuilder.buildParam(calculateDto, PriceTypeEnum.ZP01);
        Map priceModelVoMap = this.priceModelVoService.handleSearchPrice(searchPrice);
        BigDecimal resultPrice = BigDecimal.ZERO;
        if (Objects.nonNull(priceModelVoMap)) {
            for (Map.Entry entry : priceModelVoMap.entrySet()) {
                PriceModelVo value = (PriceModelVo)entry.getValue();
                BigDecimal price = value.getPrice();
                if (Objects.isNull(price)) continue;
                resultPrice = price;
                break;
            }
        }
        HashMap resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), resultPrice);
        return resultMap;
    }
}

