/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.salesgoal;

import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AllMonthAllProductDiscountTaskRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(AllMonthAllProductDiscountTaskRegister.class);
    @Autowired(required=false)
    private SalesGoalService salesGoalService;

    public String getVariableCode() {
        return "AllMonthAllProductDiscountTaskNumber";
    }

    public String getVariableName() {
        return "\u5168\u6708\u5168\u54c1\u6298\u540e\u4efb\u52a1\u91cf\uff08\u4e3b\u4f53\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank((CharSequence)calculateDto.getYearMonthLy(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.isNotEmpty((CharSequence)calculateDto.getSalesOrgCode()) || StringUtils.isNotEmpty((CharSequence)calculateDto.getCustomerCode()) ? 1 : 0) != 0, (String)"[\u5168\u6708\u5168\u54c1\u6298\u540e\u4efb\u52a1\u91cf] \u9500\u552e\u7ec4\u7ec7\u7f16\u7801\u548c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        SalesGoalDto salesGoalDto = new SalesGoalDto();
        if (CollectionUtils.isEmpty((Collection)calculateDto.getCustomerCodeList())) {
            salesGoalDto.setSalesOrgCode(calculateDto.getSalesOrgCode());
        }
        salesGoalDto.setYearMonthLy(calculateDto.getYearMonthLy());
        salesGoalDto.setCustomerCodeList((List)Lists.newArrayList((Iterable)calculateDto.getCustomerCodeList()));
        List salesGoalVos = this.salesGoalService.listForVariableCal(salesGoalDto);
        if (CollectionUtils.isEmpty((Collection)salesGoalVos)) {
            HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
            return resultMap;
        }
        salesGoalVos = salesGoalVos.stream().filter(salesGoalVo -> salesGoalVo.getYearSalesTypeCode().equals("contract")).collect(Collectors.toList());
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(4);
        resultMap.put(this.getVariableCode(), salesGoalVos.stream().map(SalesGoalVo::getTaskQuantity).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
        return resultMap;
    }
}

