/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.subcompany;

import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import com.biz.crm.tpm.business.variable.local.register.subcompany.common.SubComSalesPlanParamBuilder;
import com.biz.crm.tpm.business.variable.local.utils.BigDecimalUtils;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AmountDeliveredBeforeConversionRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(AmountDeliveredBeforeConversionRegister.class);
    @Autowired
    private SalesPlanService salesPlanService;

    public String getVariableCode() {
        return "amountDeliveredBeforeConversion";
    }

    public String getVariableName() {
        return "\u6708\u5ea6\u9500\u552e\u8ba1\u5212\u6298\u524d\u51fa\u5e93\u989d\uff08\u5206\u5b50\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionEnumList = Lists.newArrayList();
        functionEnumList.add(VariableFunctionEnum.AUDIT);
        return functionEnumList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        List<SalesPlanDto> paramList = SubComSalesPlanParamBuilder.buildOtherParamList(calculateDto);
        SalesPlanDto customerDto = this.setOtherParam(paramList.get(0), calculateDto);
        SalesPlanDto terminalDto = this.setOtherParam(paramList.get(1), calculateDto);
        List list = this.salesPlanService.findByConditions(customerDto);
        if (CollectionUtils.isEmpty((Collection)list) && Objects.nonNull(terminalDto)) {
            list = this.salesPlanService.findByConditions(terminalDto);
        }
        HashMap resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return resultMap;
        }
        BigDecimal theoryIncomeTotal = list.stream().map(SalesPlanVo::getTheoryIncome).collect(Collectors.toList()).stream().reduce(BigDecimal.ZERO, (xva$0, xva$1) -> BigDecimalUtils.sum(xva$0, xva$1));
        resultMap.put(this.getVariableCode(), theoryIncomeTotal);
        return resultMap;
    }

    private SalesPlanDto salesParamsAssignment(CalculateDto calculateDto) {
        SalesPlanDto salesPlan = new SalesPlanDto();
        salesPlan.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        salesPlan.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        salesPlan.setErpCode(calculateDto.getCustomerErpCode());
        salesPlan.setSalesOrgCode(calculateDto.getSalesOrgCode());
        salesPlan.setProductCode(calculateDto.getProductCode());
        return salesPlan;
    }

    private void salesParamsValidate(CalculateDto calculateDto) {
        Validate.notNull((Object)calculateDto.getCustomerErpCode(), (String)"\u5ba2\u6237MDG\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getSalesOrgCode(), (String)"\u9500\u552e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getYearMonthLy(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private SalesPlanDto setOtherParam(SalesPlanDto salesPlan, CalculateDto calculateDto) {
        if (Objects.isNull(salesPlan)) {
            return null;
        }
        Validate.notNull((Object)calculateDto.getSalesOrgCode(), (String)"\u9500\u552e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        salesPlan.setSalesOrgCode(calculateDto.getSalesOrgCode());
        return salesPlan;
    }
}

