/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.subcompany;

import com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator.common.ExecutorIndicatorParamReflectEnum;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.dto.SourceCustomVariableDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaCustomVariableRegister;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModelProperty;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ExecuteIndicatorCommonRegister
implements FormulaCustomVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(ExecuteIndicatorCommonRegister.class);
    @Autowired(required=false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    private static final String detailPlanItemCode = "detailPlanItemCode";

    public String getVariableCode() {
        return "executorIndicator";
    }

    public String getVariableName() {
        return "\u6267\u884c\u6307\u6807\u7c7b\u901a\u7528\u53d8\u91cf\uff08\u5206\u5b50\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        return list;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto, SourceCustomVariableDto sourceCustomVariableDto) {
        AuditExecuteIndicatorDto dto;
        AuditExecuteIndicatorDto dto2;
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        resultMap.put(sourceCustomVariableDto.getVariableCode(), BigDecimal.ZERO);
        Validate.notBlank((CharSequence)sourceCustomVariableDto.getParamsJson(), (String)"\u53d8\u91cf[%s]\u53c2\u6570\u672a\u914d\u7f6e\uff01", (Object[])new Object[]{sourceCustomVariableDto.getVariableName()});
        List<String> params = Arrays.asList(sourceCustomVariableDto.getParamsJson().split(","));
        if (!CollectionUtils.isEmpty((Collection)calculateDto.getCustomerCodeList())) {
            params.add(ExecutorIndicatorParamReflectEnum.customerCodeList.getSrcProperty());
            params.remove(ExecutorIndicatorParamReflectEnum.customerCode.getSrcProperty());
        }
        List<Object> paramList = new ArrayList();
        if (params.contains(detailPlanItemCode)) {
            dto2 = this.buildDto(calculateDto, Lists.newArrayList((Object[])new String[]{detailPlanItemCode}));
            paramList.add(dto2);
        } else {
            dto2 = this.buildDto(calculateDto, params);
            paramList = this.buildParamList(dto2);
        }
        List list = new ArrayList();
        Iterator<Object> iterator = paramList.iterator();
        while (iterator.hasNext() && CollectionUtils.isEmpty(list = this.auditExecuteIndicatorService.findListForVariable(dto = (AuditExecuteIndicatorDto)iterator.next()))) {
        }
        if (CollectionUtils.isEmpty(list)) {
            return resultMap;
        }
        BigDecimal value = list.stream().filter(e -> Objects.nonNull(e.getIndicatorValue())).map(AuditExecuteIndicatorVo::getIndicatorValue).reduce(BigDecimal.ZERO, BigDecimal::add);
        resultMap.put(sourceCustomVariableDto.getVariableCode(), value);
        return resultMap;
    }

    public AuditExecuteIndicatorDto buildDto(CalculateDto calculateDto, List<String> params) {
        AuditExecuteIndicatorDto dto = new AuditExecuteIndicatorDto();
        Class<CalculateDto> srcClazz = CalculateDto.class;
        Class<AuditExecuteIndicatorDto> destClazz = AuditExecuteIndicatorDto.class;
        HashSet<String> set = new HashSet<String>();
        for (String propertyName : params) {
            if (set.contains(propertyName)) continue;
            set.add(propertyName);
            Field srcFiled = null;
            Field destFiled = null;
            Object o = null;
            ExecutorIndicatorParamReflectEnum reflectEnum = null;
            try {
                srcFiled = srcClazz.getDeclaredField(propertyName);
                srcFiled.setAccessible(true);
                o = srcFiled.get(calculateDto);
                reflectEnum = ExecutorIndicatorParamReflectEnum.getBySrcProperty(propertyName);
                Validate.notNull((Object)((Object)reflectEnum), (String)"\u5c5e\u6027[%s]\u672a\u5b9a\u4e49\u76ee\u6807\u6620\u5c04\u5c5e\u6027\uff01", (Object[])new Object[]{propertyName});
                destFiled = destClazz.getDeclaredField(reflectEnum.getDestProperty());
                destFiled.setAccessible(true);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("\u516c\u5f0f\u8ba1\u7b97\u53c2\u6570[" + propertyName + "]\u672a\u5b9a\u4e49\uff01");
            }
            ApiModelProperty annotation = srcFiled.getAnnotation(ApiModelProperty.class);
            if (Objects.nonNull(annotation)) {
                String desc = StringUtils.isNotEmpty((CharSequence)annotation.value()) ? annotation.value() : (StringUtils.isNotEmpty((CharSequence)annotation.name()) ? annotation.name() : annotation.notes());
                Validate.notNull((Object)o, (String)(desc + "\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
            } else {
                Validate.notNull((Object)o, (String)"\u5c5e\u6027[%s]\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[]{propertyName});
            }
            try {
                if (reflectEnum.isSplit()) {
                    destFiled.set(dto, Arrays.asList(o.toString().split(",")));
                    continue;
                }
                if (destFiled.getType().equals(Collection.class)) {
                    destFiled.set(dto, Lists.newArrayList((Object[])new Object[]{o}));
                    continue;
                }
                destFiled.set(dto, o);
            }
            catch (IllegalAccessException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("\u516c\u5f0f\u8ba1\u7b97\u53c2\u6570[" + propertyName + "]\u8bbe\u7f6e\u76ee\u6807\u6620\u5c04\u5c5e\u6027\u5f02\u5e38\uff01");
            }
        }
        return dto;
    }

    public List<AuditExecuteIndicatorDto> buildParamList(AuditExecuteIndicatorDto dto) {
        ArrayList<AuditExecuteIndicatorDto> list = new ArrayList<AuditExecuteIndicatorDto>();
        if (StringUtils.isNotEmpty((CharSequence)dto.getCustomerCode()) || StringUtils.isNotEmpty((CharSequence)dto.getCustomerErpCode())) {
            AuditExecuteIndicatorDto customerDto = (AuditExecuteIndicatorDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, AuditExecuteIndicatorDto.class, HashSet.class, ArrayList.class, new String[0]);
            customerDto.setStoresCodes(null);
            customerDto.setStoresCode(null);
            list.add(customerDto);
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getStoresCode())) {
            AuditExecuteIndicatorDto terminalDto = (AuditExecuteIndicatorDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, AuditExecuteIndicatorDto.class, HashSet.class, ArrayList.class, new String[0]);
            terminalDto.setCustomerCode(null);
            terminalDto.setCustomerErpCode(null);
            list.add(terminalDto);
        }
        if (StringUtils.isEmpty((CharSequence)dto.getCustomerCode()) && StringUtils.isEmpty((CharSequence)dto.getCustomerErpCode()) && StringUtils.isEmpty((CharSequence)dto.getStoresCode())) {
            return Lists.newArrayList((Object[])new AuditExecuteIndicatorDto[]{dto});
        }
        return list;
    }
}

