/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.subcompany;

import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.QueryConditionDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.service.InvoiceSalesDataVoService;
import com.biz.crm.kms.business.invoice.sales.data.sdk.vo.SalesDataVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PosAmountRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(PosAmountRegister.class);
    @Autowired(required=false)
    private InvoiceSalesDataVoService salesDataVoService;

    public String getVariableCode() {
        return "posAmount";
    }

    public String getVariableName() {
        return "Pos\u91d1\u989d\uff08\u5206\u5b50\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        return list;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        this.saleDataValidate(calculateDto);
        QueryConditionDto queryCondition = new QueryConditionDto();
        this.salesDataAssignment(queryCondition, calculateDto);
        SalesDataVo salesDataVo = this.salesDataVoService.findByCondition(queryCondition);
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(1);
        if (ObjectUtils.isEmpty((Object)salesDataVo) || ObjectUtils.isEmpty((Object)salesDataVo.getSalesAmount())) {
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
            return resultMap;
        }
        resultMap.put(this.getVariableCode(), salesDataVo.getSalesAmount());
        return resultMap;
    }

    private void saleDataValidate(CalculateDto calculateDto) {
        Validate.notNull((Object)calculateDto.getStartTimeOrDate(), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getEndTimeOrDate(), (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getProductCode(), (String)"\u4ea7\u54c1\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getStoresCode(), (String)"\u95e8\u5e97\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void salesDataAssignment(QueryConditionDto queryCondition, CalculateDto calculateDto) {
        String startTimeOrDateFormat = DateUtil.format((Date)calculateDto.getStartTimeOrDate(), (String)"yyyy-MM-dd");
        String endTimeOrDateFormat = DateUtil.format((Date)calculateDto.getEndTimeOrDate(), (String)"yyyy-MM-dd");
        queryCondition.setStartTimeOrDate(startTimeOrDateFormat);
        queryCondition.setEndTimeOrDate(endTimeOrDateFormat);
        queryCondition.setGoodsCode(calculateDto.getProductCode());
        queryCondition.setDeliveryPartyCode(calculateDto.getStoresCode());
    }
}

