/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.subcompany;

import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmSapDaySalesDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.vo.TpmSapDaySalesVo;
import com.biz.crm.tpm.business.variable.local.register.subcompany.common.SapDeliveryRegisterParamBuilder;
import com.biz.crm.tpm.business.variable.local.register.subcompany.common.SubComVariableSearchCommonService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SapAllProductBeforeDiscountDeliveryAmountOneToTenRegister
extends SubComVariableSearchCommonService
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(SapAllProductBeforeDiscountDeliveryAmountOneToTenRegister.class);

    public String getVariableCode() {
        return "sapAllProductBeforeDiscountDeliveryAmountOneToTen";
    }

    public String getVariableName() {
        return "SAP\u51fa\u5e93\u989d-\u6298\u524d_\u5168\u54c1_1\u81f310\u65e5\uff08\u5206\u5b50\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank((CharSequence)calculateDto.getYearMonthLy(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<TpmSapDaySalesDto> paramList = SapDeliveryRegisterParamBuilder.buildParamList(calculateDto);
        TpmSapDaySalesDto customerDto = this.buildParam(paramList.get(0), calculateDto);
        TpmSapDaySalesDto terminalDto = this.buildParam(paramList.get(1), calculateDto);
        List<TpmSapDaySalesVo> daySalesVos = super.tpmSapDaySalesVoList1(customerDto, terminalDto);
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(1);
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (CollectionUtils.isEmpty(daySalesVos)) {
            return resultMap;
        }
        BigDecimal total = daySalesVos.stream().filter(e -> Objects.nonNull(e.getIncomeTaxIncluded())).map(TpmSapDaySalesVo::getIncomeTaxIncluded).reduce(BigDecimal.ZERO, BigDecimal::add);
        resultMap.put(this.getVariableCode(), total);
        return resultMap;
    }

    private TpmSapDaySalesDto buildParam(TpmSapDaySalesDto daySalesDto, CalculateDto calculateDto) {
        if (Objects.nonNull(daySalesDto)) {
            daySalesDto.setActivityBeginTime(calculateDto.getYearMonthLy().replaceAll("-", "") + "01");
            daySalesDto.setActivityEndTime(calculateDto.getYearMonthLy().replaceAll("-", "") + "10");
            daySalesDto.setProductCodes(null);
            daySalesDto.setBrandList(null);
            daySalesDto.setCategoryCodeList(null);
            daySalesDto.setItemCodes(null);
        }
        return daySalesDto;
    }
}

