/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.subcompany;

import com.biz.crm.mdm.business.product.level.sdk.enums.ProductLevelEnum;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmSapDaySalesDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.vo.TpmSapDaySalesVo;
import com.biz.crm.tpm.business.variable.local.register.common.VariableProductLevelService;
import com.biz.crm.tpm.business.variable.local.register.subcompany.common.SapDeliveryRegisterParamBuilder;
import com.biz.crm.tpm.business.variable.local.register.subcompany.common.SubComVariableSearchCommonService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SapPartProductDiscountDeliveryAmountRegister
extends SubComVariableSearchCommonService
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(SapPartProductDiscountDeliveryAmountRegister.class);
    @Autowired(required=false)
    private VariableProductLevelService variableProductLevelService;

    public String getVariableCode() {
        return "sapPartProductDiscountDeliveryAmount";
    }

    public String getVariableName() {
        return "SAP\u51fa\u5e93\u989d-\u6298\u540e-\u5c0f\u54c1\u9879\uff08\u5206\u5b50\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notNull((Object)calculateDto.getStartTimeOrDate(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getEndTimeOrDate(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ProductLevelVo vo = new ProductLevelVo();
        vo.setLevelLabel("1");
        Map<String, List<String>> map = this.variableProductLevelService.levelCodeMap(vo);
        List<TpmSapDaySalesDto> paramList = SapDeliveryRegisterParamBuilder.buildParamList(calculateDto);
        TpmSapDaySalesDto customerDto = this.buildParam(paramList.get(0), calculateDto, map);
        TpmSapDaySalesDto terminalDto = this.buildParam(paramList.get(1), calculateDto, map);
        List<TpmSapDaySalesVo> daySalesVos = super.tpmSapDaySalesVoList1(customerDto, terminalDto);
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(1);
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (CollectionUtils.isEmpty(daySalesVos)) {
            return resultMap;
        }
        BigDecimal total = daySalesVos.stream().filter(e -> Objects.nonNull(e.getInvoiceAmt())).map(TpmSapDaySalesVo::getInvoiceAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        resultMap.put(this.getVariableCode(), total);
        return resultMap;
    }

    private TpmSapDaySalesDto buildParam(TpmSapDaySalesDto daySalesDto, CalculateDto calculateDto, Map<String, List<String>> map) {
        if (Objects.nonNull(daySalesDto)) {
            daySalesDto.setActivityBeginTime(DateUtil.format((Date)calculateDto.getStartTimeOrDate(), (String)"yyyy-MM-dd").replaceAll("-", ""));
            daySalesDto.setActivityEndTime(DateUtil.format((Date)calculateDto.getEndTimeOrDate(), (String)"yyyy-MM-dd").replaceAll("-", ""));
            daySalesDto.setProductCodes(null);
            daySalesDto.setBrandList(map.get(ProductLevelEnum.brand.getCode()));
            daySalesDto.setCategoryCodeList(map.get(ProductLevelEnum.category.getCode()));
            daySalesDto.setItemCodes(map.get(ProductLevelEnum.items.getCode()));
        }
        return daySalesDto;
    }
}

