/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.subcompany;

import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SpreadMarketRateRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(SpreadMarketRateRegister.class);
    @Autowired(required=false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;

    public String getVariableCode() {
        return "spreadMarketRate";
    }

    public String getVariableName() {
        return "\u94fa\u5e02\u7387\uff08\u5206\u5b50\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notNull((Object)calculateDto.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getSalesOrgCode(), (String)"\u9500\u552e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getYearMonthLy(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List resultList = null;
        AuditExecuteIndicatorDto customerDto = this.buildParam(calculateDto);
        customerDto.setCustomerCode(calculateDto.getCustomerCode());
        resultList = this.auditExecuteIndicatorService.findListByCondition(customerDto);
        if (!CollectionUtils.isEmpty((Collection)resultList) && StringUtils.isNotEmpty((CharSequence)calculateDto.getStoresCode())) {
            AuditExecuteIndicatorDto terminalDto = this.buildParam(calculateDto);
            terminalDto.setStoresCodes(Arrays.asList(calculateDto.getStoresCode().split(",")));
            resultList = this.auditExecuteIndicatorService.findListByCondition(terminalDto);
        }
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return new HashMap<String, BigDecimal>();
        }
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        resultMap.put(this.getVariableCode(), ((AuditExecuteIndicatorVo)resultList.get(0)).getIndicatorValue());
        return resultMap;
    }

    private AuditExecuteIndicatorDto buildParam(CalculateDto calculateDto) {
        AuditExecuteIndicatorDto dto = new AuditExecuteIndicatorDto();
        dto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        dto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        try {
            dto.setYearAndMonth(sdf.parse(calculateDto.getYearMonthLy()));
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        dto.setSalesOrgCode(calculateDto.getSalesOrgCode());
        dto.setIndicatorCode(this.getVariableCode());
        return dto;
    }
}

