/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.subcompany;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.PriceTypeEnum;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.biz.crm.tpm.business.variable.local.register.common.PriceRegisterParamBuilder;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SubCompanyCostPriceRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(SubCompanyCostPriceRegister.class);
    @Autowired(required=false)
    private PriceModelVoService priceModelVoService;

    public String getVariableCode() {
        return "subCompanyCostPrice";
    }

    public String getVariableName() {
        return "\u6210\u672c\u4ef7-\u5206\u5b50\uff08\u5206\u5b50\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.WITHHOLDING);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        SearchPriceDto searchPrice = PriceRegisterParamBuilder.buildParam(calculateDto, PriceTypeEnum.ZMN1);
        Map priceModelVoMap = this.priceModelVoService.handleSearchPrice(searchPrice);
        log.info("\u6307\u6807\u8be2\u4ef7\u8fd4\u56de=====\u300b{}", (Object)JSONObject.toJSONString((Object)priceModelVoMap));
        BigDecimal resultPrice = BigDecimal.ZERO;
        if (Objects.nonNull(priceModelVoMap)) {
            for (Map.Entry entry : priceModelVoMap.entrySet()) {
                PriceModelVo value = (PriceModelVo)entry.getValue();
                BigDecimal price = value.getPrice();
                if (Objects.isNull(price)) continue;
                resultPrice = price;
                break;
            }
        }
        HashMap resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), resultPrice);
        return resultMap;
    }
}

