/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.subcompany.common;

import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmSapDaySalesDto;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class SapDeliveryRegisterParamBuilder {
    public static final String customer = "customer";
    public static final String terminal = "terminal";

    public static TpmSapDaySalesDto buildParam(CalculateDto calculateDto) {
        TpmSapDaySalesDto daySalesDto = SapDeliveryRegisterParamBuilder.buildCommonParam(calculateDto);
        daySalesDto.setDealerCodes(Arrays.asList(calculateDto.getCustomerErpCode().split(",")));
        if (StringUtils.isNotEmpty((CharSequence)calculateDto.getStoresCode())) {
            daySalesDto.setServiceCodes(Arrays.asList(calculateDto.getStoresCode().split(",")));
        }
        return daySalesDto;
    }

    public static List<TpmSapDaySalesDto> buildParamList(CalculateDto calculateDto) {
        ArrayList<TpmSapDaySalesDto> list = new ArrayList<TpmSapDaySalesDto>();
        TpmSapDaySalesDto customerDto = SapDeliveryRegisterParamBuilder.buildCommonParam(calculateDto);
        customerDto.setDealerCodes(Arrays.asList(calculateDto.getCustomerErpCode().split(",")));
        list.add(customerDto);
        if (StringUtils.isNotEmpty((CharSequence)calculateDto.getStoresCode())) {
            TpmSapDaySalesDto terminalDto = SapDeliveryRegisterParamBuilder.buildCommonParam(calculateDto);
            terminalDto.setServiceCodes(Arrays.asList(calculateDto.getStoresCode().split(",")));
            list.add(terminalDto);
        } else {
            list.add(null);
        }
        return list;
    }

    public static TpmSapDaySalesDto buildCommonParam(CalculateDto calculateDto) {
        Validate.notBlank((CharSequence)calculateDto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getCustomerErpCode(), (String)"\u5ba2\u6237MDG\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getSalesOrganizationErpCode(), (String)"\u9500\u552e\u673a\u6784MDG\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getDistributionChannel(), (String)"\u5206\u9500\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        TpmSapDaySalesDto daySalesDto = new TpmSapDaySalesDto();
        daySalesDto.setSpartCode(calculateDto.getBusinessFormatCode());
        daySalesDto.setSalesOrgCode(calculateDto.getSalesOrganizationErpCode());
        daySalesDto.setChannelCode(calculateDto.getDistributionChannel());
        List<Object> brandList = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)calculateDto.getBrandCode())) {
            brandList = Arrays.asList(calculateDto.getBrandCode().split(","));
        }
        if (!brandList.contains("130000")) {
            if (StringUtils.isNotEmpty((CharSequence)calculateDto.getProductCode())) {
                daySalesDto.setProductCodes(Arrays.asList(calculateDto.getProductCode().split(",")));
            } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getItemCode())) {
                daySalesDto.setItemCodes(Arrays.asList(calculateDto.getItemCode().split(",")));
            } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getCategoryCode())) {
                daySalesDto.setCategoryCodeList(Arrays.asList(calculateDto.getCategoryCode().split(",")));
            } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getBrandCode())) {
                daySalesDto.setBrandList(Arrays.asList(calculateDto.getBrandCode().split(",")));
            } else {
                throw new RuntimeException("\u4ea7\u54c1\u7f16\u7801\u3001\u4ea7\u54c1\u5c42\u7ea7\u5168\u90e8\u4e3a\u7a7a\uff01");
            }
        }
        return daySalesDto;
    }
}

