/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.subjectleveltwo;

import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public abstract class SalesTaskService {
    @Autowired(required=false)
    private SalesGoalService salesGoalService;

    public BigDecimal findSalesGoal(CalculateDto calculate, Integer queryType, String yearSalesTypeCode) {
        Validate.notNull((Object)calculate.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculate.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculate.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculate.getSalesOrgCode(), (String)"\u9500\u552e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculate.getYearMonthLy(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        SalesGoalDto salesGoalDto = new SalesGoalDto();
        BeanUtils.copyProperties((Object)calculate, (Object)salesGoalDto);
        salesGoalDto.setQueryType(queryType);
        salesGoalDto.setYearSalesTypeCode(yearSalesTypeCode);
        if (StringUtils.isNotEmpty((CharSequence)salesGoalDto.getProductCode())) {
            salesGoalDto.setProductItemCode(null);
            salesGoalDto.setProductCategoryCode(null);
            salesGoalDto.setProductBrandCode(null);
            salesGoalDto.setIncludeProductCodeList(Arrays.asList(salesGoalDto.getProductCode().split(",")));
            salesGoalDto.setProductCode(null);
        } else if (StringUtils.isNotEmpty((CharSequence)salesGoalDto.getProductItemCode())) {
            salesGoalDto.setProductCategoryCode(null);
            salesGoalDto.setProductBrandCode(null);
        } else if (StringUtils.isNotEmpty((CharSequence)salesGoalDto.getProductCategoryCode())) {
            salesGoalDto.setProductBrandCode(null);
        } else if (StringUtils.isNotEmpty((CharSequence)salesGoalDto.getProductBrandCode()) && StringUtils.equals((CharSequence)"130000", (CharSequence)salesGoalDto.getProductBrandCode())) {
            salesGoalDto.setProductBrandCode(null);
        }
        return this.salesGoalService.getSalesGoalAmount(salesGoalDto);
    }

    public BigDecimal getTaskNumber(CalculateDto calculateDto, String yearSalesTypeCode) {
        return this.findSalesGoal(calculateDto, 1, yearSalesTypeCode);
    }

    public BigDecimal getTaskAmount(CalculateDto calculateDto, String yearSalesTypeCode) {
        return this.findSalesGoal(calculateDto, 2, yearSalesTypeCode);
    }

    public BigDecimal getTaskAfterAmount(CalculateDto calculateDto, String yearSalesTypeCode) {
        return this.findSalesGoal(calculateDto, 3, yearSalesTypeCode);
    }
}

