/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.vertical;

import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.eunm.YearSalesTypeEnum;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalSumVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PerformanceSalesGoalDiscountAfterRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(PerformanceSalesGoalDiscountAfterRegister.class);
    @Autowired(required=false)
    private SalesGoalService salesGoalService;

    public String getVariableCode() {
        return "performanceSalesGoalDiscountAfter";
    }

    public String getVariableName() {
        return "\u7ee9\u6548\u7248\u9500\u552e\u4efb\u52a1\u6298\u540e\u989d(\u5782\u76f4)";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        return list;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank((CharSequence)calculateDto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getEndTimeOrDate(), (String)"\u7ed3\u675f\u65f6\u95f4/\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        SalesGoalDto dto = new SalesGoalDto();
        dto.setYearMonthLy(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM, (Date)calculateDto.getEndTimeOrDate()));
        dto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        dto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        if (StringUtils.isNotEmpty((CharSequence)calculateDto.getProductCode())) {
            dto.setProductCode(calculateDto.getProductCode());
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getItemCode())) {
            dto.setProductItemCode(calculateDto.getItemCode());
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getCategoryCode())) {
            dto.setProductCategoryCode(calculateDto.getCategoryCode());
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getBrandCode())) {
            dto.setProductBrandCode(calculateDto.getBrandCode());
        } else {
            throw new RuntimeException("\u7ee9\u6548\u7248\u9500\u552e\u4efb\u52a1\u6298\u540e\u989d\uff0c\u672a\u5f55\u5165\u4ea7\u54c1\u6216\u8005\u4ea7\u54c1\u5c42\u7ea7\u4fe1\u606f");
        }
        if (StringUtils.isNotEmpty((CharSequence)calculateDto.getStoresCode())) {
            dto.setTerminalCode(calculateDto.getStoresCode());
        } else {
            Validate.notBlank((CharSequence)calculateDto.getRetailBusinessmanCode(), (String)"\u96f6\u552e\u5546\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)calculateDto.getActivityOrgCode(), (String)"\u533a\u57df\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
            dto.setSystemCode(calculateDto.getRetailBusinessmanCode());
            dto.setRegionCode(calculateDto.getActivityOrgCode());
        }
        dto.setYearSalesTypeCode(YearSalesTypeEnum.ACHIEVEMENT.getCode());
        SalesGoalSumVo salesGoalSumVo = this.salesGoalService.findDiscountAfterAndDeliveryQuantity(dto);
        BigDecimal deliveryDiscountSalesAmount = Objects.nonNull(salesGoalSumVo) && Objects.nonNull(salesGoalSumVo.getDeliveryDiscountSalesAmount()) ? salesGoalSumVo.getDeliveryDiscountSalesAmount() : BigDecimal.ZERO;
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(4);
        resultMap.put(this.getVariableCode(), deliveryDiscountSalesAmount);
        return resultMap;
    }
}

